#if 0
#elif defined(__arm64__) && __arm64__
// Generated by Apple Swift version 6.2 effective-5.10 (swiftlang-6.2.0.19.9 clang-1700.3.19.1)
#ifndef LICENSESPRING_SWIFT_H
#define LICENSESPRING_SWIFT_H
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wgcc-compat"

#if !defined(__has_include)
# define __has_include(x) 0
#endif
#if !defined(__has_attribute)
# define __has_attribute(x) 0
#endif
#if !defined(__has_feature)
# define __has_feature(x) 0
#endif
#if !defined(__has_warning)
# define __has_warning(x) 0
#endif

#if __has_include(<swift/objc-prologue.h>)
# include <swift/objc-prologue.h>
#endif

#pragma clang diagnostic ignored "-Wauto-import"
#if defined(__OBJC__)
#include <Foundation/Foundation.h>
#endif
#if defined(__cplusplus)
#include <cstdint>
#include <cstddef>
#include <cstdbool>
#include <cstring>
#include <stdlib.h>
#include <new>
#include <type_traits>
#else
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>
#include <string.h>
#endif
#if defined(__cplusplus)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wnon-modular-include-in-framework-module"
#if defined(__arm64e__) && __has_include(<ptrauth.h>)
# include <ptrauth.h>
#else
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wreserved-macro-identifier"
# ifndef __ptrauth_swift_value_witness_function_pointer
#  define __ptrauth_swift_value_witness_function_pointer(x)
# endif
# ifndef __ptrauth_swift_class_method_pointer
#  define __ptrauth_swift_class_method_pointer(x)
# endif
#pragma clang diagnostic pop
#endif
#pragma clang diagnostic pop
#endif

#if !defined(SWIFT_TYPEDEFS)
# define SWIFT_TYPEDEFS 1
# if __has_include(<uchar.h>)
#  include <uchar.h>
# elif !defined(__cplusplus)
typedef unsigned char char8_t;
typedef uint_least16_t char16_t;
typedef uint_least32_t char32_t;
# endif
typedef float swift_float2  __attribute__((__ext_vector_type__(2)));
typedef float swift_float3  __attribute__((__ext_vector_type__(3)));
typedef float swift_float4  __attribute__((__ext_vector_type__(4)));
typedef double swift_double2  __attribute__((__ext_vector_type__(2)));
typedef double swift_double3  __attribute__((__ext_vector_type__(3)));
typedef double swift_double4  __attribute__((__ext_vector_type__(4)));
typedef int swift_int2  __attribute__((__ext_vector_type__(2)));
typedef int swift_int3  __attribute__((__ext_vector_type__(3)));
typedef int swift_int4  __attribute__((__ext_vector_type__(4)));
typedef unsigned int swift_uint2  __attribute__((__ext_vector_type__(2)));
typedef unsigned int swift_uint3  __attribute__((__ext_vector_type__(3)));
typedef unsigned int swift_uint4  __attribute__((__ext_vector_type__(4)));
#endif

#if !defined(SWIFT_PASTE)
# define SWIFT_PASTE_HELPER(x, y) x##y
# define SWIFT_PASTE(x, y) SWIFT_PASTE_HELPER(x, y)
#endif
#if !defined(SWIFT_METATYPE)
# define SWIFT_METATYPE(X) Class
#endif
#if !defined(SWIFT_CLASS_PROPERTY)
# if __has_feature(objc_class_property)
#  define SWIFT_CLASS_PROPERTY(...) __VA_ARGS__
# else
#  define SWIFT_CLASS_PROPERTY(...) 
# endif
#endif
#if !defined(SWIFT_RUNTIME_NAME)
# if __has_attribute(objc_runtime_name)
#  define SWIFT_RUNTIME_NAME(X) __attribute__((objc_runtime_name(X)))
# else
#  define SWIFT_RUNTIME_NAME(X) 
# endif
#endif
#if !defined(SWIFT_COMPILE_NAME)
# if __has_attribute(swift_name)
#  define SWIFT_COMPILE_NAME(X) __attribute__((swift_name(X)))
# else
#  define SWIFT_COMPILE_NAME(X) 
# endif
#endif
#if !defined(SWIFT_METHOD_FAMILY)
# if __has_attribute(objc_method_family)
#  define SWIFT_METHOD_FAMILY(X) __attribute__((objc_method_family(X)))
# else
#  define SWIFT_METHOD_FAMILY(X) 
# endif
#endif
#if !defined(SWIFT_NOESCAPE)
# if __has_attribute(noescape)
#  define SWIFT_NOESCAPE __attribute__((noescape))
# else
#  define SWIFT_NOESCAPE 
# endif
#endif
#if !defined(SWIFT_RELEASES_ARGUMENT)
# if __has_attribute(ns_consumed)
#  define SWIFT_RELEASES_ARGUMENT __attribute__((ns_consumed))
# else
#  define SWIFT_RELEASES_ARGUMENT 
# endif
#endif
#if !defined(SWIFT_WARN_UNUSED_RESULT)
# if __has_attribute(warn_unused_result)
#  define SWIFT_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
# else
#  define SWIFT_WARN_UNUSED_RESULT 
# endif
#endif
#if !defined(SWIFT_NORETURN)
# if __has_attribute(noreturn)
#  define SWIFT_NORETURN __attribute__((noreturn))
# else
#  define SWIFT_NORETURN 
# endif
#endif
#if !defined(SWIFT_CLASS_EXTRA)
# define SWIFT_CLASS_EXTRA 
#endif
#if !defined(SWIFT_PROTOCOL_EXTRA)
# define SWIFT_PROTOCOL_EXTRA 
#endif
#if !defined(SWIFT_ENUM_EXTRA)
# define SWIFT_ENUM_EXTRA 
#endif
#if !defined(SWIFT_CLASS)
# if __has_attribute(objc_subclassing_restricted)
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# else
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# endif
#endif
#if !defined(SWIFT_RESILIENT_CLASS)
# if __has_attribute(objc_class_stub)
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME) __attribute__((objc_class_stub))
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_class_stub)) SWIFT_CLASS_NAMED(SWIFT_NAME)
# else
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME)
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) SWIFT_CLASS_NAMED(SWIFT_NAME)
# endif
#endif
#if !defined(SWIFT_PROTOCOL)
# define SWIFT_PROTOCOL(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
# define SWIFT_PROTOCOL_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
#endif
#if !defined(SWIFT_EXTENSION)
# define SWIFT_EXTENSION(M) SWIFT_PASTE(M##_Swift_, __LINE__)
#endif
#if !defined(OBJC_DESIGNATED_INITIALIZER)
# if __has_attribute(objc_designated_initializer)
#  define OBJC_DESIGNATED_INITIALIZER __attribute__((objc_designated_initializer))
# else
#  define OBJC_DESIGNATED_INITIALIZER 
# endif
#endif
#if !defined(SWIFT_ENUM_ATTR)
# if __has_attribute(enum_extensibility)
#  define SWIFT_ENUM_ATTR(_extensibility) __attribute__((enum_extensibility(_extensibility)))
# else
#  define SWIFT_ENUM_ATTR(_extensibility) 
# endif
#endif
#if !defined(SWIFT_ENUM)
# define SWIFT_ENUM(_type, _name, _extensibility) enum _name : _type _name; enum SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# if __has_feature(generalized_swift_name)
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) enum _name : _type _name SWIFT_COMPILE_NAME(SWIFT_NAME); enum SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# else
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) SWIFT_ENUM(_type, _name, _extensibility)
# endif
#endif
#if !defined(SWIFT_UNAVAILABLE)
# define SWIFT_UNAVAILABLE __attribute__((unavailable))
#endif
#if !defined(SWIFT_UNAVAILABLE_MSG)
# define SWIFT_UNAVAILABLE_MSG(msg) __attribute__((unavailable(msg)))
#endif
#if !defined(SWIFT_AVAILABILITY)
# define SWIFT_AVAILABILITY(plat, ...) __attribute__((availability(plat, __VA_ARGS__)))
#endif
#if !defined(SWIFT_WEAK_IMPORT)
# define SWIFT_WEAK_IMPORT __attribute__((weak_import))
#endif
#if !defined(SWIFT_DEPRECATED)
# define SWIFT_DEPRECATED __attribute__((deprecated))
#endif
#if !defined(SWIFT_DEPRECATED_MSG)
# define SWIFT_DEPRECATED_MSG(...) __attribute__((deprecated(__VA_ARGS__)))
#endif
#if !defined(SWIFT_DEPRECATED_OBJC)
# if __has_feature(attribute_diagnose_if_objc)
#  define SWIFT_DEPRECATED_OBJC(Msg) __attribute__((diagnose_if(1, Msg, "warning")))
# else
#  define SWIFT_DEPRECATED_OBJC(Msg) SWIFT_DEPRECATED_MSG(Msg)
# endif
#endif
#if defined(__OBJC__)
#if !defined(IBSegueAction)
# define IBSegueAction 
#endif
#endif
#if !defined(SWIFT_EXTERN)
# if defined(__cplusplus)
#  define SWIFT_EXTERN extern "C"
# else
#  define SWIFT_EXTERN extern
# endif
#endif
#if !defined(SWIFT_CALL)
# define SWIFT_CALL __attribute__((swiftcall))
#endif
#if !defined(SWIFT_INDIRECT_RESULT)
# define SWIFT_INDIRECT_RESULT __attribute__((swift_indirect_result))
#endif
#if !defined(SWIFT_CONTEXT)
# define SWIFT_CONTEXT __attribute__((swift_context))
#endif
#if !defined(SWIFT_ERROR_RESULT)
# define SWIFT_ERROR_RESULT __attribute__((swift_error_result))
#endif
#if defined(__cplusplus)
# define SWIFT_NOEXCEPT noexcept
#else
# define SWIFT_NOEXCEPT 
#endif
#if !defined(SWIFT_C_INLINE_THUNK)
# if __has_attribute(always_inline)
# if __has_attribute(nodebug)
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline)) __attribute__((nodebug))
# else
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline))
# endif
# else
#  define SWIFT_C_INLINE_THUNK inline
# endif
#endif
#if defined(_WIN32)
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL __declspec(dllimport)
#endif
#else
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL 
#endif
#endif
#if defined(__OBJC__)
#if __has_feature(objc_modules)
#if __has_warning("-Watimport-in-framework-header")
#pragma clang diagnostic ignored "-Watimport-in-framework-header"
#endif
@import Foundation;
@import ObjectiveC;
@import Security;
#endif

#endif
#pragma clang diagnostic ignored "-Wproperty-attribute-mismatch"
#pragma clang diagnostic ignored "-Wduplicate-method-arg"
#if __has_warning("-Wpragma-clang-attribute")
# pragma clang diagnostic ignored "-Wpragma-clang-attribute"
#endif
#pragma clang diagnostic ignored "-Wunknown-pragmas"
#pragma clang diagnostic ignored "-Wnullability"
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"
#pragma clang diagnostic ignored "-Wunsafe-buffer-usage"

#if __has_attribute(external_source_symbol)
# pragma push_macro("any")
# undef any
# pragma clang attribute push(__attribute__((external_source_symbol(language="Swift", defined_in="LicenseSpring",generated_declaration))), apply_to=any(function,enum,objc_interface,objc_category,objc_protocol))
# pragma pop_macro("any")
#endif

#if defined(__OBJC__)

/// License authorization method.
typedef SWIFT_ENUM_NAMED(NSInteger, LSAuthorizationMethod, "AuthorizationMethod", open) {
  LSAuthorizationMethodUnknown = 0,
  LSAuthorizationMethodLicenseKey = 1,
  LSAuthorizationMethodUser = 2,
};

@class NSString;
@class NSDate;
/// Application available version information.
SWIFT_CLASS_NAMED("AvailableVersion")
@interface LSAvailableVersion : NSObject
/// Available version.
@property (nonatomic, copy) NSString * _Nonnull version;
/// Release date.
@property (nonatomic, copy) NSDate * _Nonnull releaseDate;
- (nonnull instancetype)initWithVersion:(NSString * _Nonnull)version releaseDate:(NSDate * _Nonnull)releaseDate OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class LSConfiguration;
@class NSURL;
/// Entry point to the LicenseSpring SDK
/// Use to obtain the license or common product information
SWIFT_CLASS_NAMED("BaseManager")
@interface LSBaseManager : NSObject
/// Init LicenseManager with configuration
/// \param configuration Configuration of LicenseManager
///
///
/// throws:
/// <code>LSError</code> if input configuration is wrong
- (nullable instancetype)initWithConfiguration:(LSConfiguration * _Nonnull)configuration error:(NSError * _Nullable * _Nullable)error OBJC_DESIGNATED_INITIALIZER;
/// Manager configuration
@property (nonatomic, strong) LSConfiguration * _Nonnull configuration;
/// Filesystem path to the license.
@property (nonatomic, readonly, copy) NSURL * _Nonnull licenseFile;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class LSLicense;
/// Entry point to the LicenseSpring SDK
/// Class for performing basic requests to LicenseSpring backend and managing license bundles
SWIFT_CLASS_NAMED("BundleManager")
@interface LSBundleManager : LSBaseManager
/// Initializes the BundleManager with the given configuration
/// \param configuration LicenseSpring configuration object
///
///
/// throws:
/// <code>LSError</code> if configuration is invalid
- (nullable instancetype)initWithConfiguration:(LSConfiguration * _Nonnull)configuration error:(NSError * _Nullable * _Nullable)error OBJC_DESIGNATED_INITIALIZER;
/// Activated Bundle or empty dictionary if no license is active.
@property (nonatomic, copy) NSDictionary<NSString *, LSLicense *> * _Nonnull cachedLicenses;
/// Activate the bundle using license key.
/// \param licenseKey License key for the product.
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Activated bundle.
- (NSDictionary<NSString *, LSLicense *> * _Nullable)activateBundleWithLicenseKey:(NSString * _Nonnull)licenseKey error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate the license bundle using username and password.
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
/// \param serverID license ID, typically 64-bit id.
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.    @objc
///
/// returns:
/// Activated bundle.
- (NSDictionary<NSString *, LSLicense *> * _Nullable)activateBundleWithUsername:(NSString * _Nonnull)username password:(NSString * _Nonnull)password serverId:(int64_t)serverId error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate the bundle using idToken
/// \param idToken 
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Activated bundle.
- (NSDictionary<NSString *, LSLicense *> * _Nullable)activateBundleWithIdToken:(NSString * _Nonnull)idToken error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate the bundle using code
/// \param code 
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Activated bundle.
- (NSDictionary<NSString *, LSLicense *> * _Nullable)activateBundleWithCode:(NSString * _Nonnull)code error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Deactivates the license bundle using licenseKey.
/// \param licenseKey License key for the product
///
/// \param removeLocalData flag to remove local bundle data
///
///
/// returns:
/// True if the deactivation is successfull
- (BOOL)deactivateBundleWithLicenseKey:(NSString * _Nonnull)licenseKey removeLocalData:(BOOL)removeLocalData SWIFT_WARN_UNUSED_RESULT;
/// Deactivates the license bundle using username and password.
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
/// \param removeLocalData flag to remove local bundle data
///
///
/// returns:
/// True if the deactivation is successfull
- (BOOL)deactivateBundleWithUsername:(NSString * _Nonnull)username password:(NSString * _Nonnull)password removeLocalData:(BOOL)removeLocalData SWIFT_WARN_UNUSED_RESULT;
/// Deactivates the license bundle using idToken and customerAccountCode.
/// \param idToken 
///
/// \param customerAccountCode .
///
/// \param removeLocalData flag to remove local bundle data
///
///
/// returns:
/// True if the deactivation is successfull
- (BOOL)deactivateBundleWithIdToken:(NSString * _Nonnull)idToken customerAccountCode:(NSString * _Nonnull)customerAccountCode removeLocalData:(BOOL)removeLocalData SWIFT_WARN_UNUSED_RESULT;
/// Deactivates the license bundle using code and customerAccountCode.
/// \param code 
///
/// \param customerAccountCode .
///
/// \param removeLocalData flag to remove local bundle data
///
///
/// returns:
/// True if the deactivation is successfull
- (BOOL)deactivateBundleWithCode:(NSString * _Nonnull)code customerAccountCode:(NSString * _Nonnull)customerAccountCode removeLocalData:(BOOL)removeLocalData SWIFT_WARN_UNUSED_RESULT;
/// Check bundle for validity on the LicenseSpring platform.
/// \param licenseKey License key for the product.
///
///
/// throws:
/// Error if remote or local checks fail.
///
/// returns:
/// Current bundle.
- (NSDictionary<NSString *, LSLicense *> * _Nullable)checkBundleWithLicenseKey:(NSString * _Nonnull)licenseKey error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Check bundle for validity on the LicenseSpring platform.
/// \param username User ID, typically email in lowercase.
///
///
/// throws:
/// Error if remote or local checks fail.
///
/// returns:
/// Current bundle.
- (NSDictionary<NSString *, LSLicense *> * _Nullable)checkBundleWithUsername:(NSString * _Nonnull)username error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Retrieve URL for Single Sign-On license activation.
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// URL for Single Sign-On.
- (NSURL * _Nullable)requestSSOURLAndReturnError:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate the license using license activation response file.
/// \param activationResponseFile Activation response file location.
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Activated license bundle.
- (NSDictionary<NSString *, LSLicense *> * _Nullable)activateBundleOffline:(NSURL * _Nonnull)activationResponseFile error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Creates offline activation file request.
/// \param licenseKey License key to be activated offline.
///
/// \param preferredLocation Optional custom activation request file location. ‘~/Desktop/ls_activation.req’ by default.
///
///
/// throws:
/// Error if create activation file fails. May be of <code>LSError</code> type.
///
/// returns:
/// Location of offline activation file request.
- (NSURL * _Nullable)createOfflineActivationFileWithLicenseKey:(NSString * _Nonnull)licenseKey preferredLocation:(NSURL * _Nullable)preferredLocation error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Creates offline activation file request.
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
/// \param preferredLocation Optional custom activation request file location. ‘~/Desktop/ls_activation.req’ by default.
///
/// \param serverID serverID, server-side license identifier, typically 64-bit id.
///
///
/// throws:
/// Error if create activation file fails. May be of <code>LSError</code> type.
///
/// returns:
/// Location of offline activation file request.
- (NSURL * _Nullable)createOfflineActivationFileWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password preferredLocation:(NSURL * _Nullable)preferredLocation serverID:(int64_t)serverID error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Creates the deactivate bundle offline request
/// \param licenseKey licenseKey: License key to be activated offline.
///
- (NSURL * _Nullable)deactivateBundleOfflineWithLicenseKey:(NSString * _Nonnull)licenseKey serverID:(int64_t)serverID preferredLocation:(NSURL * _Nullable)preferredLocation error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Creates the deactivate bundle offline request
/// \param username User ID, typically email in lowercase.
///
- (NSURL * _Nullable)deactivateBundleOfflineWithUsername:(NSString * _Nonnull)username serverID:(int64_t)serverID preferredLocation:(NSURL * _Nullable)preferredLocation error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// Company related to the license
SWIFT_CLASS_NAMED("Company")
@interface LSCompany : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@protocol LicenseCryptor;
@class ExtendedOptions;
@class OAuthCredentials;
/// LicenseSpring SDK configuration.
SWIFT_CLASS_NAMED("Configuration")
@interface LSConfiguration : NSObject <NSCopying>
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
/// API key acquired from LicenseSpring.
@property (nonatomic, copy) NSString * _Nonnull apiKey;
/// Shared key acquired from LicenseSpring.
@property (nonatomic, copy) NSString * _Nonnull sharedKey;
/// Product code code acquired from LicenseSpring.
@property (nonatomic, copy) NSString * _Nonnull productCode;
/// Application name. Defaults to main application bundle name if not set.
@property (nonatomic, copy) NSString * _Nonnull appName;
/// Application version. Defaults to main application bundle short version if not set.
@property (nonatomic, copy) NSString * _Nonnull appVersion;
/// Customer group (account) code that is required for SSO.
/// note:
/// Meaningful for user-based auth only. If you don’t plan to provide SSO you can ignore this method.
/// By default empty. Contact support to get more details implementing SSO.
@property (nonatomic, copy) NSString * _Nullable customerAccountCode;
/// Air gap public key.
@property (nonatomic, copy) NSString * _Nullable airgapKey;
/// Custom name of local license file.
@property (nonatomic, copy) NSString * _Nonnull licenseFileName;
/// Custom directory containing local license file.
@property (nonatomic, copy) NSURL * _Nonnull licenseDirectoryPath;
/// Alternate base URL for LicenseSpring API.
/// note:
/// In general should not be used in client code.
@property (nonatomic, copy) NSURL * _Nonnull serviceURL;
/// Custom hardware ID of the device.
@property (nonatomic, copy) NSString * _Nonnull hardwareID;
/// Boolean indicates if SDK should send host, local IP and MAC to the LicenseSpring platform.
@property (nonatomic) BOOL collectHostNameAndLocalIP;
/// Timeout value for network operations.
@property (nonatomic) NSTimeInterval networkTimeout;
/// Timeout value for network operations.
@property (nonatomic, strong) id <LicenseCryptor> _Nonnull licenseCryptor;
/// HTTPs proxy host.
@property (nonatomic, copy) NSString * _Nullable proxyHost;
/// HTTPs proxy port.
@property (nonatomic) uint16_t proxyPort;
/// License grace period in seconds.
/// If not set, then default will be 48 hours.
/// Set 0 to disable grace period.
/// For cloud floating licenses grace period on license check is enabled
/// if more than an hour of floating period remains.
@property (nonatomic) NSTimeInterval gracePeriod;
/// ClientID
@property (nonatomic, copy) NSString * _Nonnull client_id;
/// Client Secret
@property (nonatomic, copy) NSString * _Nonnull client_secret;
/// Crypto Provider Key
@property (nonatomic, copy) NSString * _Nonnull CryptoProviderKey;
/// IsOAuth
@property (nonatomic) BOOL isOauth;
/// ProtectOfflineActivation
@property (nonatomic, readonly) BOOL isGuardFileEnabled;
/// ExtendedOptions
@property (nonatomic, strong) ExtendedOptions * _Nullable extendedOptions;
/// IsLoggingEnabled
@property (nonatomic) BOOL isLoggingEnabled;
/// Whether detection of Virtual machines is enabled
@property (nonatomic, readonly) BOOL isVMDetectionEnabled;
/// In case VM detection enabled returns true if app currently running in virtualized environment
@property (nonatomic, readonly) BOOL isVM;
/// Detected virtual machine name
@property (nonatomic, readonly, copy) NSString * _Nullable detectedVMName;
/// PublicKey
@property (nonatomic, copy) NSString * _Nonnull publicKey;
/// PublicKey from base64 String
@property (nonatomic, readonly) SecKeyRef _Nullable publicKeyFromBase64;
- (nonnull instancetype)initWithApiKey:(NSString * _Nonnull)apiKey sharedKey:(NSString * _Nonnull)sharedKey productCode:(NSString * _Nonnull)productCode publicKey:(NSString * _Nullable)publicKey extendedOptions:(ExtendedOptions * _Nullable)extendedOptions OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithOAuthCredentials:(OAuthCredentials * _Nonnull)oAuthCredentials productCode:(NSString * _Nonnull)productCode publicKey:(NSString * _Nullable)publicKey extendedOptions:(ExtendedOptions * _Nullable)extendedOptions OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface LSConfiguration (SWIFT_EXTENSION(LicenseSpring))
/// Full path to the license file.
@property (nonatomic, readonly, copy) NSURL * _Nonnull licenseFile;
@end

/// License authorization method.
typedef SWIFT_ENUM_NAMED(NSInteger, LSConsumptionPeriod, "ConsumptionPeriod", open) {
  LSConsumptionPeriodUnknown = 0,
  LSConsumptionPeriodDaily = 1,
  LSConsumptionPeriodWeekly = 2,
  LSConsumptionPeriodMonthly = 3,
  LSConsumptionPeriodAnnually = 4,
};

/// License custom field information.
SWIFT_CLASS_NAMED("CustomField")
@interface LSCustomField : NSObject
/// Custom field name.
@property (nonatomic, copy) NSString * _Nonnull name;
/// Custom field value.
@property (nonatomic, copy) NSString * _Nonnull value;
- (nonnull instancetype)initWithName:(NSString * _Nonnull)name value:(NSString * _Nonnull)value OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS("_TtC13LicenseSpring14CustomFieldDto")
@interface CustomFieldDto : NSObject
/// The name of the custom field
@property (nonatomic, copy) NSString * _Nonnull name;
/// The value of the custom field
@property (nonatomic, copy) NSString * _Nonnull value;
/// Reserved for future use
@property (nonatomic, copy) NSString * _Nullable valueType;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class NSData;
/// LicenseSpring Customer information.
SWIFT_CLASS_NAMED("Customer")
@interface LSCustomer : NSObject
/// Customer email address.
@property (nonatomic, copy) NSString * _Nullable email;
/// Customer first name.
@property (nonatomic, copy) NSString * _Nullable firstName;
/// Customer last name.
@property (nonatomic, copy) NSString * _Nullable lastName;
/// Customer company name.
@property (nonatomic, copy) NSString * _Nullable company;
/// Customer phone number.
@property (nonatomic, copy) NSString * _Nullable phone;
/// Customer address.
@property (nonatomic, copy) NSString * _Nullable address;
/// Customer city.
@property (nonatomic, copy) NSString * _Nullable city;
/// Customer state.
@property (nonatomic, copy) NSString * _Nullable state;
/// Customer country.
@property (nonatomic, copy) NSString * _Nullable country;
/// Customer postcode/zipcoder.
@property (nonatomic, copy) NSString * _Nullable postcode;
/// Customer reference.
@property (nonatomic, copy) NSString * _Nullable reference;
/// Metadata JSON.
@property (nonatomic, copy) NSData * _Nullable metadata;
/// Creates <code>Customer</code> instance with parameters.
/// \param email Customer email address.
///
/// \param firstName Customer first name.
///
/// \param lastName Customer last name.
///
/// \param company Customer company name.
///
/// \param phone Customer phone number.
///
/// \param address Customer address.
///
/// \param city Customer city.
///
/// \param state Customer state.
///
/// \param country Customer country.
///
/// \param postcode Customer postcode/zipcoder.
///
/// \param reference Customer reference.
///
/// \param metadata Customer metadata JSON.
///
- (nonnull instancetype)initWithEmail:(NSString * _Nullable)email firstName:(NSString * _Nullable)firstName lastName:(NSString * _Nullable)lastName company:(NSString * _Nullable)company phone:(NSString * _Nullable)phone address:(NSString * _Nullable)address city:(NSString * _Nullable)city state:(NSString * _Nullable)state country:(NSString * _Nullable)country postcode:(NSString * _Nullable)postcode reference:(NSString * _Nullable)reference metadata:(NSData * _Nullable)metadata OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

typedef SWIFT_ENUM(NSInteger, DeviceIDAlgorithm, open) {
  DeviceIDAlgorithmDefault = 0,
};

SWIFT_CLASS_NAMED("DeviceVariable")
@interface LSDeviceVariable : NSObject
/// Variable ID.
@property (nonatomic) NSInteger id;
/// Name of the variable.
@property (nonatomic, copy) NSString * _Nonnull variable;
/// Value of the variable.
@property (nonatomic, copy) NSString * _Nonnull value;
/// Date when the variable has been set.
@property (nonatomic, copy) NSDate * _Nonnull createdAt;
/// Device ID related the variable is bound to.
@property (nonatomic) NSInteger deviceID;
- (nonnull instancetype)initWithId:(NSInteger)id variable:(NSString * _Nonnull)variable value:(NSString * _Nonnull)value createdAt:(NSDate * _Nonnull)createdAt deviceID:(NSInteger)deviceID OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class ProxySettings;
SWIFT_CLASS("_TtC13LicenseSpring15ExtendedOptions")
@interface ExtendedOptions : NSObject
/// Whether to enable detection of running in a virtual machine.
@property (nonatomic) BOOL enableVMDetection;
/// Optional alternate key for authorization or license lookup.
@property (nonatomic, copy) NSString * _Nullable alternateKey;
/// Full proxy settings, including credentials and URI.
@property (nonatomic, strong) ProxySettings * _Nonnull proxy;
/// Timeout in milliseconds for cloud ID request (separate from general network timeout).
@property (nonatomic) NSInteger cloudIdRequestTimeout;
/// Algorithm to use for generating device ID.
@property (nonatomic) enum DeviceIDAlgorithm deviceIdAlgorithm;
/// Additional custom headers to include in HTTP requests.
@property (nonatomic, copy) NSDictionary<NSString *, NSString *> * _Nonnull customHeaders;
/// Optional bundle code identifier.
@property (nonatomic, copy) NSString * _Nullable bundleCode;
/// Whether to skip checking local time during airgap activation.
@property (nonatomic) BOOL airgapSkipLocalTimeCheck;
@property (nonatomic) BOOL protectOfflineActivation;
- (nonnull instancetype)initWithEnableVMDetection:(BOOL)enableVMDetection alternateKey:(NSString * _Nullable)alternateKey proxy:(ProxySettings * _Nonnull)proxy cloudIdRequestTimeout:(NSInteger)cloudIdRequestTimeout deviceIdAlgorithm:(enum DeviceIDAlgorithm)deviceIdAlgorithm customHeaders:(NSDictionary<NSString *, NSString *> * _Nonnull)customHeaders bundleCode:(NSString * _Nullable)bundleCode airgapSkipLocalTimeCheck:(BOOL)airgapSkipLocalTimeCheck protectOfflineActivation:(BOOL)protectOfflineActivation OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS("_TtC13LicenseSpring14FloatingClient")
@interface FloatingClient : NSObject
@property (nonatomic, readonly, strong) LSConfiguration * _Nonnull configuration;
/// Init FloatingClient with configuration.
/// \param configuration Configuration of FloatingClient.
///
///
/// throws:
/// <code>LSError</code> if input configuration is wrong.
- (nullable instancetype)initWithConfiguration:(LSConfiguration * _Nonnull)configuration error:(NSError * _Nullable * _Nullable)error OBJC_DESIGNATED_INITIALIZER;
/// Filesystem path to the license.
@property (nonatomic, readonly, copy) NSURL * _Nonnull licenseFile;
/// Activated License or nil if no license is active.
@property (nonatomic, readonly, strong) LSLicense * _Nullable currentLicense;
/// Register client with given id.
/// Send register license request to the Floating server.
/// \param userID User or instance id for license registration, it can be anything - email, host or domain name, handle, etc.
///
///
/// throws:
/// <code>LSError</code> if registration fails.
///
/// returns:
/// Shared pointer to License if registration succeeded, throws exceptions in case of errors.
- (LSLicense * _Nullable)registerWithUserID:(NSString * _Nonnull)userID error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Unregister client with given id.
/// \param id User or instance id, it can be anything - email, host or domain name, handle, etc.
///
///
/// throws:
/// <code>LSError</code> if unregistration fails.
- (BOOL)unregisterWithUserID:(NSString * _Nonnull)userID error:(NSError * _Nullable * _Nullable)error;
/// Remove license file and internal SDK files if any of them exist.
/// note:
/// Typically should be called after license deactivation in the app uninstaller.
///
/// throws:
/// Error if clearing fails.
- (BOOL)clearLocalStorageAndReturnError:(NSError * _Nullable * _Nullable)error;
/// Helper method to check connection to the Floating server.
///
/// returns:
/// <code>true</code> if SDK is able to connect to the Floating server and <code>false</code> otherwise.
- (BOOL)checkConnection SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Information about the app related to the License.
SWIFT_CLASS_NAMED("InstallationFile")
@interface LSInstallationFile : NSObject
/// InstallationFile hash.
@property (nonatomic, copy) NSString * _Nonnull hashMD5;
/// InstallationFile version.
@property (nonatomic, copy) NSString * _Nonnull version;
/// InstallationFile URL.
@property (nonatomic, copy) NSString * _Nonnull installationFileLink;
/// App version that is required to install this InstallationFile.
@property (nonatomic, copy) NSString * _Nullable requiredVersion;
/// InstallationFile release date.
@property (nonatomic, copy) NSDate * _Nullable releaseDate;
/// InstallationFile environment.
@property (nonatomic, copy) NSString * _Nullable environment;
/// InstallationFile Eula link.
@property (nonatomic, copy) NSString * _Nullable eulaLink;
/// InstallationFile release notes link.
@property (nonatomic, copy) NSString * _Nullable releaseNotesLink;
/// InstallationFile size in bytes.
@property (nonatomic) uint64_t size;
/// InstallationFile channel.
@property (nonatomic, copy) NSString * _Nullable channel;
- (nonnull instancetype)initWithHashMD5:(NSString * _Nonnull)hashMD5 version:(NSString * _Nonnull)version installationFileLink:(NSString * _Nonnull)installationFileLink OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class LSUser;
enum LSLicenseType : NSInteger;
enum LSLicenseStatus : NSInteger;
@class LSLicenseFeature;
@class LSProductDetails;
/// The License. Contains information about the license and set of methods to manupulate it.
SWIFT_CLASS_NAMED("License")
@interface LSLicense : NSObject
/// License configuration. Do NOT modify directly.
@property (nonatomic, readonly, strong) LSConfiguration * _Nonnull configuration;
/// License key. Exists for key-based license.
@property (nonatomic, readonly, copy) NSString * _Nullable licenseKey;
/// License user. Exists for user-based license.
@property (nonatomic, readonly, strong) LSUser * _Nullable user;
/// Product code.
@property (nonatomic, readonly, copy) NSString * _Nonnull productCode;
/// Type of license.
@property (nonatomic, readonly) enum LSLicenseType licenseType;
/// Information about license customer, commonly it’s a person or organization associated with the license.
@property (nonatomic, readonly, strong) LSCustomer * _Nonnull customer;
/// Period when the license is valid.
@property (nonatomic, readonly, copy) NSDate * _Nullable validityPeriod;
/// Maintenance period for the license.
@property (nonatomic, readonly, copy) NSDate * _Nullable maintenancePeriod;
/// The first date when the license can be activated
@property (nonatomic, readonly, copy) NSDate * _Nullable startDate;
/// The date of the last sync with the LicenseSpring platform.
@property (nonatomic, readonly, copy) NSDate * _Nonnull lastSyncDate;
/// If license is trial.
@property (nonatomic, readonly) BOOL isTrial;
/// If license is active.
@property (nonatomic, readonly) BOOL isActive;
/// If license is enabled.
@property (nonatomic, readonly) BOOL isEnabled;
/// If license was activated offline.
@property (nonatomic, readonly) BOOL isOfflineActivated;
/// If license was activated via Air-Gap.
@property (nonatomic, readonly) BOOL isAirGapActivated;
/// PolicyID related to AirGap activation.
@property (nonatomic, readonly) NSInteger policyID;
/// Installation information related to the license.
/// note:
/// To get actual installation file information, call <code>synchronize</code> method first.
@property (nonatomic, readonly, strong) LSInstallationFile * _Nullable installationFile;
/// Hardware ID related to the license.
@property (nonatomic, readonly, copy) NSString * _Nonnull hardwareID;
/// License ID related to the license.
@property (nonatomic, readonly) int64_t serverID;
/// Indicates whether negative consumption is allowed for Consumption feature.
/// Meaningful only for Consumption license features.
@property (nonatomic, readonly) BOOL allowNegativeConsumptions;
/// Is running a license on a virtual machine prevented.
@property (nonatomic, readonly) BOOL preventVM;
/// Activation date related to the license
@property (nonatomic, readonly, copy) NSDate * _Nullable activationDate;
/// Company  related to the license
@property (nonatomic, readonly, strong) LSCompany * _Nullable company;
/// Current state of the license.
@property (nonatomic, readonly) enum LSLicenseStatus state;
/// If license have been expired.
@property (nonatomic, readonly) BOOL isExpired;
/// Fast and simple way to check current local state of the license.
/// note:
/// Equivalent to isEnabled && isActive && !isExpired.
/// note:
/// It’s just basic check, you cannot be 100% sure that license is valid without online license check.
/// You still need to perform full license check for better safety.
///
/// returns:
/// If license is valid.
@property (nonatomic, readonly) BOOL isValid;
/// If license copy is unlicensed.
@property (nonatomic, readonly) BOOL isUnlicensedCopy;
/// Indicates whether the maintenance period for the current license has expired.
@property (nonatomic, readonly) BOOL isMaintenancePeriodExpired;
/// Grace period of the license.
/// note:
/// Meaningful only for <code>subscription</code> license.
@property (nonatomic, readonly) NSTimeInterval gracePeriod;
/// Check license for validity on the LicenseSpring platform.
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
///
/// throws:
/// Error if remote or local checks fail.
- (BOOL)fullCheckWithEnv:(NSString * _Nullable)env error:(NSError * _Nullable * _Nullable)error;
/// Asynchronous wrapper for full license check that avoids blocking the main thread.
/// \param env Optional environment identifier.
///
/// \param completion Completion handler called with success or error.
///
- (void)fullCheckAsyncWithEnv:(NSString * _Nullable)env completion:(void (^ _Nonnull)(NSError * _Nullable))completion;
/// Check license for validity offline.
///
/// throws:
/// Error if check fails.
///
/// returns:
/// Boolean indicates if local check passed or not.
- (BOOL)localCheckAndReturnError:(NSError * _Nullable * _Nullable)error;
/// Retrieves fresh license information from the LicenseSpring platform.
///
/// throws:
/// Error if synchronization fails.
- (BOOL)synchronizeWithEnv:(NSString * _Nullable)env error:(NSError * _Nullable * _Nullable)error;
/// How many times license already been activated.
@property (nonatomic, readonly) NSInteger timesActivated;
/// How many times license can be activated.
@property (nonatomic, readonly) NSInteger maxActivations;
/// Deactivate the license.
///
/// throws:
/// Error if deactivation fails.
- (BOOL)deactivateAndReturnError:(NSError * _Nullable * _Nullable)error;
/// Updates license with offline update file.
/// \param file Update file location.
///
///
/// throws:
/// Error if update fails.
- (BOOL)updateOfflineWith:(NSURL * _Nonnull)file error:(NSError * _Nullable * _Nullable)error;
/// Creates offline deactivation file request.
/// \param preferredRequestFile Optional custom deactivation request file location. ‘~/Desktop/ls_deactivation.req’ by default.
///
///
/// throws:
/// Error if creation of deactivation request fails.
///
/// returns:
/// Location of offline deactivation file request.
- (NSURL * _Nullable)deactivateOfflineWithPreferredRequestFile:(NSURL * _Nullable)preferredRequestFile error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Product features available for the license.
@property (nonatomic, readonly, copy) NSArray<LSLicenseFeature *> * _Nonnull features;
/// Updates feature consumption by some diff (positive or negative).
/// \param code Feature code.
///
/// \param difference Difference of consumption number.
///
///
/// throws:
/// Error if update fails.
- (BOOL)updateFeatureConsumptionWithCode:(NSString * _Nonnull)code difference:(NSInteger)difference error:(NSError * _Nullable * _Nullable)error;
/// Sync Consumption Feature(s) with the LicenseSpring platform.
/// note:
/// Meaningful only for Consumption features.
/// \param code Code of the license feature that need to be synchronized. If <code>nil</code>, sync all consumption features.
///
///
/// throws:
/// Error if sync fails.
- (BOOL)syncFeatureConsumptionWithCode:(NSString * _Nullable)code error:(NSError * _Nullable * _Nullable)error;
/// If the license is floating type.
/// Meaningful only for Floating license.
@property (nonatomic, readonly) BOOL isFloating;
/// If the license is floating type.
/// Meaningful only for Floating license.
@property (nonatomic, readonly) BOOL isOfflineFloating;
/// Maximum number of simultaneous license users (devices or instances).
/// Meaningful only for Floating license.
@property (nonatomic, readonly) NSInteger maxFloatingUsers;
/// Current number of floatings slots in use, including this user (instance).
/// The value can be actualized with <code>synchronize</code> method call.
/// Meaningful only for Floating license.
@property (nonatomic, readonly) NSInteger floatingInUseCount;
/// Timeout of the floating license.
/// Meaningful only for Floating license.
@property (nonatomic, readonly) NSTimeInterval floatingTimeout;
/// Floating user (client) or instance id that was set during registration via <code>FloatingClient</code>.
/// Meaningful only for Floating license.
@property (nonatomic, readonly, copy) NSString * _Nullable floatingClientId;
/// Floating license validity end date.
/// Meaningful only for Floating license.
@property (nonatomic, readonly, copy) NSDate * _Nullable floatingEndDate;
/// How many times license has been transferred between devices.
@property (nonatomic, readonly) NSInteger transferCount;
/// Register floating license using floatingClientId
/// In order to keep floating license alive you should check (register) it periodically.
/// This is equivalent to <code>synchronize</code> method call.
/// Meaningful only for Floating license.
- (BOOL)registerFloatingLicenseAndReturnError:(NSError * _Nullable * _Nullable)error;
/// Revoke floating license, typically should be called at the end of app execution.
/// This call will also release (return) borrowed license.
- (BOOL)releaseFloatingLicenseAndReturnError:(NSError * _Nullable * _Nullable)error;
/// If the license is borrowed.
/// Meaningful only for Floating license.
@property (nonatomic, readonly) BOOL isBorrowed;
/// If the license can be borrowed.
/// Meaningful only for Floating license.
@property (nonatomic, readonly) BOOL canBorrow;
/// The license max borrow time in seconds.
/// Meaningful only for Floating license.
@property (nonatomic, readonly) NSTimeInterval maxBorrowTime;
/// IsBundleActivated
@property (nonatomic, readonly) BOOL isBundleActivated;
/// Borrow floating license for provided time interval.
/// Meaningful only for floating licenses.
/// note:
/// More at <a href="https://docs.licensespring.com/docs/apiv4floatingborrow-1">/api/v4/floating/borrow</a>.
/// \param interval Borrow interval. If the value exceeds <code>maxBorrowTime</code>, it will be trimmed to the maximum.
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
- (BOOL)borrowFor:(NSTimeInterval)interval error:(NSError * _Nullable * _Nullable)error;
/// Borrow floating license till provided end date.
/// Meaningful only for floating licenses.
/// note:
/// More at <a href="https://docs.licensespring.com/docs/apiv4floatingborrow-1">/api/v4/floating/borrow</a>.
/// \param date Borrow end date. Pass <code>nil</code> to borrow the license for max possible period.
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
- (BOOL)borrowUntil:(NSDate * _Nullable)date error:(NSError * _Nullable * _Nullable)error;
/// Custom data fields available for the license.
@property (nonatomic, readonly, copy) NSArray<LSCustomField *> * _Nonnull customFields;
/// Internal order id.
@property (nonatomic, readonly, copy) NSString * _Nullable orderStoreID;
/// Metadata JSON.
@property (nonatomic, readonly, copy) NSData * _Nullable metadata;
/// Information about the product this license is belong to.
@property (nonatomic, readonly, strong) LSProductDetails * _Nonnull productDetails;
/// Array of variables bound to license concrete device ID.
@property (nonatomic, readonly, copy) NSArray<LSDeviceVariable *> * _Nonnull deviceVariables;
/// Sends device-specific variables to the LicenseSpring platform.
/// note:
/// More at <a href="https://licensespring.kwiki.io/docs/apiv4trackdevicevariables">/api/v4/track_device_variables</a>.
/// \param variables Dictionary of name-value pairs.
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// Array of variables linked to the current running device ID.
- (BOOL)sendDeviceVariables:(NSDictionary<NSString *, NSString *> * _Nonnull)variables error:(NSError * _Nullable * _Nullable)error;
/// Requests device-specific variables from the LicenseSpring platform.
/// If succeeds, property <code>deviceVariables</code> is also updated.
/// note:
/// Please note this data will be linked to the current running device ID.
/// note:
/// More at <a href="https://licensespring.kwiki.io/docs/apiv4getdevicevariables">/api/v4/get_device_variables</a>.
///
/// throws:
/// Error if sending data fails.
- (NSArray<LSDeviceVariable *> * _Nullable)requestDeviceVariablesAndReturnError:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request all available versions for the current license.
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// An array of versions available for the license.
- (NSArray<LSAvailableVersion *> * _Nullable)requestAvailableVersionsAndReturnError:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request installation information for the current license.
/// \param version Desired product (app) version, optional. If not provided, the last available version assumed.
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// Installation information related to the license.
- (LSInstallationFile * _Nullable)requestInstallationFileWithVersion:(NSString * _Nullable)version error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Change password for user based license.
/// note:
/// More at <a href="https://docs.licensespring.com/docs/apiv4changepassword">/api/v4/change_password</a>
/// \param password Current user password.
///
/// \param newPassword New user password.
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
- (BOOL)changePasswordWithPassword:(NSString * _Nonnull)password newPassword:(NSString * _Nonnull)newPassword error:(NSError * _Nullable * _Nullable)error;
/// If unlimited number or consumptions is allowed.
/// note:
/// Meaningful only for Consumption license.
@property (nonatomic, readonly) BOOL allowUnlimitedConsumptions;
/// If reset consumption is enabled. Refer to value in <code>consumptionPeriod</code>.
/// note:
/// Meaningful only for Consumption feature type.
@property (nonatomic, readonly) BOOL isResetConsumptionEnabled;
/// Value of reset consumption period. Makes sense only if <code>isResetConsumptionEnabled</code> is <code>true</code>.
/// note:
/// Meaningful only for Consumption feature type.
@property (nonatomic, readonly) enum LSConsumptionPeriod consumptionPeriod;
/// If it’s allowed to go over <code>maxConsumptionOverage</code>.
/// note:
/// Meaningful only for Consumption based license.
@property (nonatomic, readonly) BOOL isConsumptionOverageAllowed;
/// Maximum extra consumption value or 0 for <code>unlimited</code> value.
/// 0 if license type is not Consumption.
@property (nonatomic, readonly) NSInteger maxConsumptionOverage;
/// Change local consumption counter for consumption license.
/// note:
/// Meaningful only for Consumption based license.
/// \param difference Consumption value to be added or removed (if passed as negative).
///
///
/// throws:
/// Error if sending data fails.
- (BOOL)updateConsumptionsWithDifference:(NSInteger)difference error:(NSError * _Nullable * _Nullable)error;
/// Current total consumption or 0 if license type is not Consumption.
/// note:
/// Meaningful only for Consumption based license.
@property (nonatomic, readonly) NSInteger consumptions;
/// Maximum consumption value or 0 if license type is not Consumption.
/// note:
/// Meaningful only for Consumption based license.
@property (nonatomic, readonly) NSInteger maxComsumptions;
/// Number of local consumptions not synchornized with LicenseSpring platform.
/// May be negative.
/// note:
/// Meaningful only for Consumption feature type.
@property (nonatomic, readonly) NSInteger localConsumptionsDelta;
/// Sync Consumption license with the server.
/// note:
/// Meaningful only for Consumption based license.
///
/// throws:
/// Error if sync fails.
- (BOOL)syncConsumptionsAndReturnError:(NSError * _Nullable * _Nullable)error;
- (BOOL)registerFloatingFeature:(LSLicenseFeature * _Nonnull)licenseFeature error:(NSError * _Nullable * _Nullable)error;
- (BOOL)releaseFloatingFeature:(LSLicenseFeature * _Nonnull)licenseFeature error:(NSError * _Nullable * _Nullable)error;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_PROTOCOL("_TtP13LicenseSpring14LicenseCryptor_")
@protocol LicenseCryptor
- (NSData * _Nullable)encrypt:(NSData * _Nonnull)data SWIFT_WARN_UNUSED_RESULT;
- (NSData * _Nullable)decrypt:(NSData * _Nonnull)data SWIFT_WARN_UNUSED_RESULT;
@end

enum LSLicenseFeatureType : NSInteger;
/// License feature information.
SWIFT_CLASS_NAMED("LicenseFeature")
@interface LSLicenseFeature : NSObject
@property (nonatomic, readonly, copy) NSString * _Nonnull id;
/// Feature name.
@property (nonatomic, copy) NSString * _Nonnull name;
/// Feature code.
@property (nonatomic, copy) NSString * _Nonnull code;
/// Feature type.
@property (nonatomic) enum LSLicenseFeatureType featureType;
/// Feature type.
@property (nonatomic, copy) NSDate * _Nullable expirationDate;
/// Maximum consumption of the feature.
/// Meaningful only for consumption feature type.
@property (nonatomic) NSInteger maxConsumptions;
/// Current total consumption or 0 if license type is not Consumption.
/// note:
/// Meaningful only for Consumption feature type.
@property (nonatomic) NSInteger consumptions;
/// If unlimited number or consumptions is allowed.
/// note:
/// Meaningful only for Consumption feature type.
@property (nonatomic) BOOL allowUnlimitedConsumptions;
/// If reset consumption is enabled. Refer to value in <code>consumptionPeriod</code>.
/// note:
/// Meaningful only for Consumption feature type.
@property (nonatomic) BOOL isResetConsumptionEnabled;
/// Value of reset consumption period. Makes sense only if <code>isResetConsumptionEnabled</code> is <code>true</code>.
/// note:
/// Meaningful only for Consumption feature type.
@property (nonatomic) enum LSConsumptionPeriod consumptionPeriod;
/// Number of local consumptions not synchornized with LicenseSpring platform.
/// May be negative.
/// note:
/// Meaningful only for Consumption feature type.
@property (nonatomic) NSInteger localConsumptionsDelta;
/// If it’s allowed to go over <code>maxConsumptionOverage</code>.
/// note:
/// Meaningful only for Consumption feature type.
@property (nonatomic) BOOL isConsumptionOverageAllowed;
/// Maximum extra consumption value or 0 for <code>unlimited</code> value.
/// 0 if feature type is not Consumption.
@property (nonatomic) NSInteger maxConsumptionOverage;
/// Metadata JSON.
@property (nonatomic, copy) NSData * _Nullable metadata;
/// Indicates whether negative consumption is allowed for Consumption feature.
/// Meaningful only for Consumption license features.
@property (nonatomic) BOOL allowNegativeConsumptions;
- (nonnull instancetype)initWithName:(NSString * _Nonnull)name code:(NSString * _Nonnull)code featureType:(enum LSLicenseFeatureType)featureType isFloating:(BOOL)isFloating isOfflineFloating:(BOOL)isOfflineFloating OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// License feature type.
typedef SWIFT_ENUM_NAMED(NSInteger, LSLicenseFeatureType, "LicenseFeatureType", open) {
  LSLicenseFeatureTypeUnknown = 0,
  LSLicenseFeatureTypeActivation = 1,
  LSLicenseFeatureTypeConsumption = 2,
};

@class UserLicensesData;
/// Entry point to the LicenseSpring SDK
/// Use to obtain the license or common product information
SWIFT_CLASS_NAMED("LicenseManager")
@interface LSLicenseManager : LSBaseManager
/// Init LicenseManager with configuration
/// \param configuration Configuration of LicenseManager
///
///
/// throws:
/// <code>LSError</code> if input configuration is wrong
- (nullable instancetype)initWithConfiguration:(LSConfiguration * _Nonnull)configuration error:(NSError * _Nullable * _Nullable)error OBJC_DESIGNATED_INITIALIZER;
/// Activated License or nil if no license is active.
@property (nonatomic, readonly, strong) LSLicense * _Nullable currentLicense;
/// Activate the license using license key.
/// \param licenseKey License key for the product.
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Activated license.
- (LSLicense * _Nullable)activateLicenseWithLicenseKey:(NSString * _Nonnull)licenseKey error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate the license using a license key asynchronously.
/// \param licenseKey License key for the product.
///
/// \param completion Completion handler called with the result of the activation.
/// Returns <code>License</code> if activation succeeds, or <code>Error</code> if activation fails.
/// The error may be of <code>LSError</code> type.
///
- (void)activateLicenseWithLicenseKey:(NSString * _Nonnull)licenseKey completion:(void (^ _Nonnull)(LSLicense * _Nullable, NSError * _Nullable))completion;
/// Activate the license using user and password.
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Activated license.
- (LSLicense * _Nullable)activateLicenseWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate the license using user and password asynchronously.
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
/// \param completion Completion handler called with the result of the activation.
/// Returns <code>License</code> if activation succeeds, or <code>Error</code> if activation fails.
/// The error may be of <code>LSError</code> type.
///
- (void)activateLicenseWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password completion:(void (^ _Nonnull)(LSLicense * _Nullable, NSError * _Nullable))completion;
/// Activate the license using serverId.
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
/// \param serverID license ID, typically 64-bit id.
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Activated license.
- (LSLicense * _Nullable)activateLicenseWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password serverId:(int64_t)serverId error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate the license using user, password, and server ID asynchronously.
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
/// \param serverId License ID, typically a 64-bit ID.
///
/// \param completion Completion handler called with the result of the activation.
/// Returns <code>License</code> if activation succeeds, or <code>Error</code> if activation fails.
/// The error may be of <code>LSError</code> type.
///
- (void)activateLicenseWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password serverId:(int64_t)serverId completion:(void (^ _Nonnull)(LSLicense * _Nullable, NSError * _Nullable))completion;
/// Activate the license using license activation response file.
/// \param activationResponseFile Activation response file location.
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Activated license.
- (LSLicense * _Nullable)activateLicenseOffline:(NSURL * _Nonnull)activationResponseFile error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate the license using license activation response file asynchronously.
/// \param activationResponseFile Activation response file location.
///
/// \param completion Completion handler called with the result of the activation.
/// Returns <code>License</code> if activation succeeds, or <code>Error</code> if activation fails.
/// The error may be of <code>LSError</code> type.
///
- (void)activateLicenseOffline:(NSURL * _Nonnull)activationResponseFile completion:(void (^ _Nonnull)(LSLicense * _Nullable, NSError * _Nullable))completion;
/// Creates offline activation file request.
/// \param licenseKey License key to be activated offline.
///
/// \param preferredLocation Optional custom activation request file location. ‘~/Desktop/ls_activation.req’ by default.
///
///
/// throws:
/// Error if create activation file fails. May be of <code>LSError</code> type.
///
/// returns:
/// Location of offline activation file request.
- (NSURL * _Nullable)createOfflineActivationFileWithLicenseKey:(NSString * _Nonnull)licenseKey preferredLocation:(NSURL * _Nullable)preferredLocation error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Creates offline activation file request.
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
/// \param preferredLocation Optional custom activation request file location. ‘~/Desktop/ls_activation.req’ by default.
///
/// \param serverID serverID, server-side license identifier, typically 64-bit id.
///
///
/// throws:
/// Error if create activation file fails. May be of <code>LSError</code> type.
///
/// returns:
/// Location of offline activation file request.
- (NSURL * _Nullable)createOfflineActivationFileWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password preferredLocation:(NSURL * _Nullable)preferredLocation serverID:(int64_t)serverID error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Get Activation code for air gap activation.
/// \param initializationCode Code received from the air gap activation portal.
///
/// \param licenseKey License key of air gap license.
///
///
/// throws:
/// Error if generation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Air gap Activation code. Empty string in case of error.
- (NSString * _Nullable)generateAirGapActivationCodeWithInitializationCode:(NSString * _Nonnull)initializationCode licenseKey:(NSString * _Nonnull)licenseKey error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT SWIFT_AVAILABILITY(ios,introduced=13.0) SWIFT_AVAILABILITY(macos,introduced=10.15);
/// Verify Confirmation code for air gap activation.
/// \param confirmationCode Code received from the air gap activation portal.
///
/// \param licenseKey License key of air gap license.
///
/// \param policyID Policy id received from the air gap activation portal.
///
///
/// throws:
/// Error if verification fails. May be of <code>LSError</code> type.
- (BOOL)verifyAirGapConfirmationCodeWithConfirmationCode:(NSString * _Nonnull)confirmationCode licenseKey:(NSString * _Nonnull)licenseKey policyID:(NSInteger)policyID error:(NSError * _Nullable * _Nullable)error SWIFT_AVAILABILITY(ios,introduced=13.0) SWIFT_AVAILABILITY(macos,introduced=10.15);
/// Activate air gap license using policy file.
/// \param airGapPolicyFile License policy file path.
///
/// \param licenseKey License key.
///
/// \param policyID Id of the license policy.
///
///
/// throws:
/// Error if activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// License if activation succeeded.
- (LSLicense * _Nullable)activateLicenseWithAirgapPolicyFile:(NSURL * _Nonnull)policyFile licenseKey:(NSString * _Nonnull)licenseKey policyID:(NSInteger)policyID error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate air gap license using policy file asynchronously.
/// \param airGapPolicyFile License policy file path.
///
/// \param licenseKey License key.
///
/// \param policyID ID of the license policy.
///
/// \param completion Completion handler called with the result of the activation.
/// Returns <code>License</code> if activation succeeds, or <code>Error</code> if activation fails.
/// The error may be of <code>LSError</code> type.
///
- (void)activateLicenseWithAirgapPolicyFile:(NSURL * _Nonnull)policyFile licenseKey:(NSString * _Nonnull)licenseKey policyID:(NSInteger)policyID completion:(void (^ _Nonnull)(LSLicense * _Nullable, NSError * _Nullable))completion;
/// Retrieve URL for Single Sign-On license activation.
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// URL for Single Sign-On.
- (NSURL * _Nullable)requestSSOURLAndReturnError:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Retrieve URL for Single Sign-On license activation.
/// <ul>
///   <li>
///     completion:  URL for Single Sign-On if request succeeds, Error if request fails. May be of <code>LSError</code> type.
///   </li>
/// </ul>
- (void)requestSSOURLWithCompletion:(void (^ _Nonnull)(NSURL * _Nullable, NSError * _Nullable))completion;
/// Activate the license.
/// \param ssoToken id_token received from user authorization with SSO.
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Activated license.
- (LSLicense * _Nullable)activateLicenseWithSsoToken:(NSString * _Nonnull)ssoToken error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate the license using SSO token asynchronously.
/// \param ssoToken id_token received from user authorization with SSO.
///
/// \param completion Completion handler called with the result of the activation.
/// Returns <code>License</code> if activation succeeds, or <code>Error</code> if activation fails.
/// The error may be of <code>LSError</code> type.
///
- (void)activateLicenseWithSsoToken:(NSString * _Nonnull)ssoToken completion:(void (^ _Nonnull)(LSLicense * _Nullable, NSError * _Nullable))completion;
/// Request trial license from LicenseSpring platform.
/// note:
/// Combination of same hardwareID and product will ALWAYS give you the same trial key!
/// This prevents people getting new trial keys on same computer.
/// \param email Optional email for key-based products and required user email for user-based products.
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// Trial license key or user email in case of user-based product.
- (NSString * _Nullable)requestTrialKeyWith:(NSString * _Nullable)email error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request trial license from LicenseSpring platform.
/// note:
/// Combination of same hardwareID and product will ALWAYS give you the same trial key!
/// This prevents people getting new trial keys on same computer.
/// \param customer Customer information. Optional for key-based products, but required for user-based products.
///
/// \param licensePolicy License policy code. If nil, the default license policy for the product will be used.
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// Trial license key or user email in case of user-based product.
- (NSString * _Nullable)requestTrialKeyFor:(LSCustomer * _Nullable)customer licensePolicy:(NSString * _Nullable)licensePolicy error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request trial license from LicenseSpring platform.
/// note:
/// Combination of same hardwareID and product will ALWAYS give you the same trial key!
/// This prevents people getting new trial keys on same computer.
/// \param email Optional email for key-based products and required user email for user-based products.
///
/// \param completion Trial license key or user email in case of user-based product if request succeeds, Error if request fails. May be of <code>LSError</code> type.
///
- (void)requestTrialKeyWith:(NSString * _Nullable)email completion:(void (^ _Nonnull)(NSString * _Nullable, NSError * _Nullable))completion;
/// Request all available versions for the license user.
/// \param licenseKey License key.
///
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// An array of versions available for the license.
- (NSArray<LSAvailableVersion *> * _Nullable)requestAvailableVersionsWithLicenseKey:(NSString * _Nonnull)licenseKey env:(NSString * _Nullable)env error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request all available versions for the license user.
/// \param licenseKey License key.
///
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
/// \param completion An array of versions available for the license if request succeeds, Error if request fails. May be of <code>LSError</code> type.
///
- (void)requestAvailableVersionsWithLicenseKey:(NSString * _Nonnull)licenseKey env:(NSString * _Nullable)env completion:(void (^ _Nonnull)(NSArray<LSAvailableVersion *> * _Nullable, NSError * _Nullable))completion;
/// Request all available versions for the license user.
/// \param user License user name, usually email in lowercase.
///
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// An array of versions available for the license.
- (NSArray<LSAvailableVersion *> * _Nullable)requestAvailableVersionsWithUser:(NSString * _Nonnull)user env:(NSString * _Nullable)env error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request all available versions for the license user.
/// \param user License user name, usually email in lowercase.
///
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
/// \param completion An array of versions available for the license if request succeeds, Error if request fails. May be of <code>LSError</code> type.
///
- (void)requestAvailableVersionsWithUser:(NSString * _Nonnull)user env:(NSString * _Nullable)env completion:(void (^ _Nonnull)(NSArray<LSAvailableVersion *> * _Nullable, NSError * _Nullable))completion;
/// Request installation information for the license.
/// \param licenseKey License key.
///
/// \param version Desired product (app) version, optional. If not provided, the last available version assumed.
///
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// Installation information related to the license.
- (LSInstallationFile * _Nullable)requestInstallationFileWithLicenseKey:(NSString * _Nonnull)licenseKey version:(NSString * _Nullable)version env:(NSString * _Nullable)env error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request installation information for the license.
/// \param licenseKey License key.
///
/// \param version Desired product (app) version, optional. If not provided, the last available version assumed.
///
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
/// \param completion Installation information related to the license if request succeeds, Error if request fails. May be of <code>LSError</code> type.
///
- (void)requestInstallationFileWithLicenseKey:(NSString * _Nonnull)licenseKey version:(NSString * _Nullable)version env:(NSString * _Nullable)env completion:(void (^ _Nonnull)(LSInstallationFile * _Nullable, NSError * _Nullable))completion;
/// Request installation information for the license.
/// \param user License user name, usually email in lowercase.
///
/// \param version Desired product (app) version, optional. If not provided, the last available version assumed.
///
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// Installation information related to the license.
- (LSInstallationFile * _Nullable)requestInstallationFileWithUser:(NSString * _Nonnull)user version:(NSString * _Nullable)version env:(NSString * _Nullable)env error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request installation information for the license.
/// \param user License user name, usually email in lowercase.
///
/// \param version Desired product (app) version, optional. If not provided, the last available version assumed.
///
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
/// \param completion Installation information related to the license if request succeeds, Error if request fails. May be of <code>LSError</code> type.
///
- (void)requestInstallationFileWithUser:(NSString * _Nonnull)user version:(NSString * _Nullable)version env:(NSString * _Nullable)env completion:(void (^ _Nonnull)(LSInstallationFile * _Nullable, NSError * _Nullable))completion;
/// Request information about the product from LicenseSpring platform.
/// note:
/// In offline mode data will be retrieved from license file if present.
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// Product details.
- (LSProductDetails * _Nullable)requestProductDetailsWithEnv:(NSString * _Nullable)env error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request information about the product from LicenseSpring platform.
/// note:
/// In offline mode data will be retrieved from license file if present.
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
/// \param completion Product details if request succeeds, Error if request fails. May be of <code>LSError</code> type.
///
- (void)requestProductDetailsWithEnv:(NSString * _Nullable)env completion:(void (^ _Nonnull)(LSProductDetails * _Nullable, NSError * _Nullable))completion;
/// Request all the license users on every order by some customer.
/// note:
/// More at <a href="https://docs.licensespring.com/docs/apiv4customerlicenseusers">/api/v4/customer_license_users</a>
/// \param customerEmail Customer email.
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// Array of the users related to the customer.
- (NSArray<LSUser *> * _Nullable)requestLicenseUsersFor:(NSString * _Nonnull)customerEmail error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request all the license users on every order by some customer.
/// note:
/// More at <a href="https://docs.licensespring.com/docs/apiv4customerlicenseusers">/api/v4/customer_license_users</a>
/// \param customerEmail Customer email.
///
/// \param completion Array of the users related to the customer if request succeeds, Error if request fails. May be of <code>LSError</code> type.
///
- (void)requestLicenseUsersFor:(NSString * _Nonnull)customerEmail completion:(void (^ _Nonnull)(NSArray<LSUser *> * _Nullable, NSError * _Nullable))completion;
/// Change password for user based license.
/// note:
/// More at <a href="https://docs.licensespring.com/docs/apiv4changepassword">/api/v4/change_password</a>
/// \param user User email.
///
/// \param password Current user password.
///
/// \param newPassword New user password.
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
- (BOOL)changePasswordWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password newPassword:(NSString * _Nonnull)newPassword error:(NSError * _Nullable * _Nullable)error;
/// Change password for user based license.
/// note:
/// More at [/api/v4/change_password]
/// \param user User email.
///
/// \param password Current user password.
///
/// \param newPassword New user password.
///
/// \param completion Error if request fails. May be of <code>LSError</code> type.
/// [/api/v4/change_password]: https://docs.licensespring.com/docs/apiv4changepassword
///
- (void)changePasswordWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password newPassword:(NSString * _Nonnull)newPassword completion:(void (^ _Nonnull)(NSError * _Nullable))completion;
/// Helper method to check connection to the LicenseSpring platform.
///
/// returns:
/// <code>true</code> if SDK is able to connect to the LicenseSpring platform and <code>false</code> otherwise.
- (BOOL)checkConnection SWIFT_WARN_UNUSED_RESULT;
/// Helper method to check connection to the LicenseSpring platform.
/// \param completion <code>true</code> if SDK is able to connect to the LicenseSpring platform and <code>false</code> otherwise
///
- (void)checkConnectionWithCompletion:(void (^ _Nonnull)(BOOL))completion;
/// Remove license file and internal SDK files if any of them exist.
/// note:
/// Typically should be called after license deactivation in the app uninstaller.
///
/// throws:
/// Error if clearing fails.
- (BOOL)clearLocalStorageAndReturnError:(NSError * _Nullable * _Nullable)error;
/// Gets the users licences using user and password
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
///
/// returns:
/// Array of UserLicensesData
- (NSArray<UserLicensesData *> * _Nullable)getUserLicensesWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Gets the users licences using user and password
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
/// \param completion Array of UserLicensesData, Error if request fails. May be of <code>LSError</code> type.
///
- (void)getUserLicensesWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password completion:(void (^ _Nonnull)(NSArray<UserLicensesData *> * _Nullable, NSError * _Nullable))completion;
/// Version of LicenseSpring SDK
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull sdkVersion;)
+ (NSString * _Nonnull)sdkVersion SWIFT_WARN_UNUSED_RESULT;
/// Version of LicenseSpring API
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) NSInteger apiVersion;)
+ (NSInteger)apiVersion SWIFT_WARN_UNUSED_RESULT;
@end

@interface LSLicenseManager (SWIFT_EXTENSION(LicenseSpring))
/// Extract SSO license token from URL.
/// \param urlString URL-like string to extract SSO token from.
///
/// \param scheme Expected URL scheme to ensure URL is valid. If scheme mismatched, the error is thrown.
///
///
/// throws:
/// Error if <code>urlString</code> has invalid format or scheme mismatched.
///
/// returns:
/// SSO token to activate the license.
+ (NSString * _Nullable)extractSSOTokenFrom:(NSString * _Nonnull)urlString scheme:(NSString * _Nonnull)scheme error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// License status.
typedef SWIFT_ENUM_NAMED(NSInteger, LSLicenseStatus, "LicenseState", open) {
  LSLicenseStatusActive = 0,
  LSLicenseStatusInactive = 1,
  LSLicenseStatusExpired = 2,
  LSLicenseStatusDisabled = 3,
};

/// License type.
typedef SWIFT_ENUM_NAMED(NSInteger, LSLicenseType, "LicenseType", open) {
  LSLicenseTypeUnknown = 0,
  LSLicenseTypePerpetual = 1,
  LSLicenseTypeSubscription = 2,
  LSLicenseTypeTimeLimited = 3,
  LSLicenseTypeConsumption = 4,
};

/// License user class that encapsulates information about the license user
SWIFT_CLASS("_TtC13LicenseSpring11LicenseUser")
@interface LicenseUser : NSObject
/// Id of the license user
@property (nonatomic) uint64_t id;
/// License user email address
@property (nonatomic, copy) NSString * _Nullable email;
/// Is the user active
@property (nonatomic) BOOL isActive;
/// License user first name
@property (nonatomic, copy) NSString * _Nullable firstName;
/// License user last name
@property (nonatomic, copy) NSString * _Nullable lastName;
/// License user phone number
@property (nonatomic, copy) NSString * _Nullable phone;
/// Does the user use initial password or already changed the password
/// True if initial password in use and false otherwise
@property (nonatomic) BOOL isInitialPassword;
/// License user initial password
@property (nonatomic, copy) NSString * _Nullable initialPassword;
/// License id of the user’s license
@property (nonatomic) uint64_t licenseId;
/// Store id of the order
@property (nonatomic, copy) NSString * _Nullable orderStoreId;
/// Id of the order
@property (nonatomic) uint64_t orderId;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Container class for OAuth credentials. Used for license manager initialization instead of api/public key.
SWIFT_CLASS("_TtC13LicenseSpring16OAuthCredentials")
@interface OAuthCredentials : NSObject
/// OAuth client ID.
@property (nonatomic, copy) NSString * _Nonnull clientId;
/// OAuth client secret.
@property (nonatomic, copy) NSString * _Nonnull clientSecret;
/// Key used for default ICryptoProvider implementation. You can ignore this if you will provide a custom ICryptoProvider, otherwise you need to provide a cryptography key.
@property (nonatomic, copy) NSString * _Nonnull cryptoProviderKey;
- (nullable instancetype)initWithClientId:(NSString * _Nonnull)clientId clientSecret:(NSString * _Nonnull)clientSecret error:(NSError * _Nullable * _Nullable)error OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// LicenseSpring Product details.
SWIFT_CLASS_NAMED("ProductDetails")
@interface LSProductDetails : NSObject
/// Product name.
@property (nonatomic, copy) NSString * _Nonnull productName;
/// Product short code.
@property (nonatomic, copy) NSString * _Nonnull productCode;
/// Authorization method of the product.
@property (nonatomic) enum LSAuthorizationMethod authorizationMethod;
/// Is trial allowed for the product or not.
@property (nonatomic) BOOL isTrialAllowed;
/// Trial period in days.
@property (nonatomic) NSInteger trialPeriod;
/// Is overages allowed for the product or not.
@property (nonatomic) BOOL isOveragesAllowed;
/// Maximum overages count.
@property (nonatomic) NSInteger maxOverages;
/// Metadata JSON.
@property (nonatomic, copy) NSData * _Nullable metadata;
/// Company  related to the license
@property (nonatomic, strong) LSCompany * _Nullable company;
- (nonnull instancetype)initWithProductName:(NSString * _Nonnull)productName productCode:(NSString * _Nonnull)productCode authorizationMethod:(enum LSAuthorizationMethod)authorizationMethod OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS("_TtC13LicenseSpring13ProxySettings")
@interface ProxySettings : NSObject
@property (nonatomic, copy) NSString * _Nullable proxyUri;
@property (nonatomic, copy) NSString * _Nullable user;
@property (nonatomic, copy) NSString * _Nullable password;
@property (nonatomic) BOOL useDefaultCredentials;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithProxyUri:(NSString * _Nonnull)proxyUri useDefaultCredentials:(BOOL)useDefaultCredentials OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password proxyUri:(NSString * _Nullable)proxyUri OBJC_DESIGNATED_INITIALIZER;
@end

/// LicenseSpring User information.
SWIFT_CLASS_NAMED("User")
@interface LSUser : NSObject
/// User email.
@property (nonatomic, copy) NSString * _Nonnull email;
/// User id.
@property (nonatomic) NSInteger id;
/// User true email.
@property (nonatomic, copy) NSString * _Nullable trueEmail;
/// Date when the user has been created.
@property (nonatomic, copy) NSDate * _Nullable createdAt;
/// Date when the user information has been updated.
@property (nonatomic, copy) NSDate * _Nullable updatedAt;
/// If the user is active.
@property (nonatomic) BOOL isActive;
/// If the user is manager.
@property (nonatomic) BOOL isManager;
/// User last login date (UTC).
@property (nonatomic, copy) NSDate * _Nullable lastLogin;
/// User initial password.
@property (nonatomic, copy) NSString * _Nullable initialPassword;
/// If password is initial.
@property (nonatomic) BOOL isInitialPassword;
/// User first name.
@property (nonatomic, copy) NSString * _Nullable firstName;
/// User last name.
@property (nonatomic, copy) NSString * _Nullable lastName;
/// User phone number.
@property (nonatomic, copy) NSString * _Nullable phoneNumber;
- (nonnull instancetype)initWithEmail:(NSString * _Nonnull)email OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS("_TtC13LicenseSpring11UserLicense")
@interface UserLicense : NSObject
/// Internal id of the license. Use this property for activating a specific license if a user has multiple licenses for the same product.
@property (nonatomic) int64_t id;
/// Id of the license in the LicenseSpring platform.
@property (nonatomic, copy) NSString * _Nullable orderStoreId;
/// Is license currently activated.
@property (nonatomic) BOOL licenseActive;
/// Is license currently enabled.
@property (nonatomic) BOOL licenseEnabled;
/// Type of the license (perpetual, subscription, time-limited, or consumption).
@property (nonatomic, readonly) enum LSLicenseType licenseType;
/// Is the license a trial version.
@property (nonatomic) BOOL isTrial;
/// Maximum number of users for this license.
@property (nonatomic) NSInteger maxLicenseUsers;
/// Date until which the license is valid.
@property (nonatomic, readonly, copy) NSDate * _Nullable validityPeriod;
/// Is maintenance period enabled.
@property (nonatomic) BOOL enableMaintenancePeriod;
/// Date until which the maintenance period is active.
@property (nonatomic, readonly, copy) NSDate * _Nullable maintenancePeriod;
/// Is grace period allowed (for subscription based licenses).
@property (nonatomic) BOOL allowGracePeriod;
/// Grace period in hours (for subscription based licenses).
@property (nonatomic) NSInteger gracePeriod;
/// Maximum number of license activations.
@property (nonatomic) NSInteger maxActivations;
/// Is unlimited number of activations allowed.
@property (nonatomic) BOOL allowUnlimitedActivations;
/// Number of time the license has been activated.
@property (nonatomic) NSInteger timesActivated;
/// First day of license activation. License can not be activated before this date.
@property (nonatomic, readonly, copy) NSDate * _Nullable startDate;
/// Number of license transfers. License transfer is an activation on a device different from the device it was last activated on.
@property (nonatomic) NSInteger transferCount;
/// Maximum number of times a license can be transfered between devices.
@property (nonatomic) NSInteger maxTransfers;
/// Are license overages allowed. In a consumption license, an overage is an additional usage beyond the predefined limit set during license creation.
@property (nonatomic) BOOL allowOverages;
/// Maximum number of license overages.
@property (nonatomic) NSInteger maxOverages;
/// Is the license a floating cloud license.
@property (nonatomic) BOOL isFloatingCloud;
/// Is the license a floating license.
@property (nonatomic) BOOL isFloating;
/// Time interval in minutes in which the end user application will need to perform a license check in order to remain registered to the license.
@property (nonatomic) int64_t floatingTimeout;
/// Can a floating license be borrowed.
@property (nonatomic) BOOL canBorrow;
/// Maximum number of hours a floating license can be borrowed for.
@property (nonatomic) int64_t maxBorrowTime;
/// Is running a license on a virtual machine prevented.
@property (nonatomic) BOOL preventVm;
/// License custom fields.
@property (nonatomic, copy) NSArray<LSCustomField *> * _Nonnull customFields;
/// License features.
@property (nonatomic, copy) NSArray<LSLicenseFeature *> * _Nonnull licenseFeatures;
/// License customer.
@property (nonatomic, strong) LSCustomer * _Nullable customer;
/// If the license is using a hardware key for authentication.
@property (nonatomic) BOOL isHardwareKeyAuthenticated;
/// Is the license airgapped.
@property (nonatomic) BOOL isAirGapped;
/// License metadata.
@property (nonatomic, copy) NSString * _Nullable metadata;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS("_TtC13LicenseSpring16UserLicensesData")
@interface UserLicensesData : NSObject
@property (nonatomic, readonly, strong) UserLicense * _Nullable license;
@property (nonatomic, readonly, strong) LicenseUser * _Nullable user;
- (nonnull instancetype)initWithUserLicense:(UserLicense * _Nonnull)userLicense licenseUser:(LicenseUser * _Nonnull)licenseUser OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

#endif
#if __has_attribute(external_source_symbol)
# pragma clang attribute pop
#endif
#if defined(__cplusplus)
#endif
#pragma clang diagnostic pop
#endif

#elif defined(__x86_64__) && __x86_64__
// Generated by Apple Swift version 6.2 effective-5.10 (swiftlang-6.2.0.19.9 clang-1700.3.19.1)
#ifndef LICENSESPRING_SWIFT_H
#define LICENSESPRING_SWIFT_H
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wgcc-compat"

#if !defined(__has_include)
# define __has_include(x) 0
#endif
#if !defined(__has_attribute)
# define __has_attribute(x) 0
#endif
#if !defined(__has_feature)
# define __has_feature(x) 0
#endif
#if !defined(__has_warning)
# define __has_warning(x) 0
#endif

#if __has_include(<swift/objc-prologue.h>)
# include <swift/objc-prologue.h>
#endif

#pragma clang diagnostic ignored "-Wauto-import"
#if defined(__OBJC__)
#include <Foundation/Foundation.h>
#endif
#if defined(__cplusplus)
#include <cstdint>
#include <cstddef>
#include <cstdbool>
#include <cstring>
#include <stdlib.h>
#include <new>
#include <type_traits>
#else
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>
#include <string.h>
#endif
#if defined(__cplusplus)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wnon-modular-include-in-framework-module"
#if defined(__arm64e__) && __has_include(<ptrauth.h>)
# include <ptrauth.h>
#else
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wreserved-macro-identifier"
# ifndef __ptrauth_swift_value_witness_function_pointer
#  define __ptrauth_swift_value_witness_function_pointer(x)
# endif
# ifndef __ptrauth_swift_class_method_pointer
#  define __ptrauth_swift_class_method_pointer(x)
# endif
#pragma clang diagnostic pop
#endif
#pragma clang diagnostic pop
#endif

#if !defined(SWIFT_TYPEDEFS)
# define SWIFT_TYPEDEFS 1
# if __has_include(<uchar.h>)
#  include <uchar.h>
# elif !defined(__cplusplus)
typedef unsigned char char8_t;
typedef uint_least16_t char16_t;
typedef uint_least32_t char32_t;
# endif
typedef float swift_float2  __attribute__((__ext_vector_type__(2)));
typedef float swift_float3  __attribute__((__ext_vector_type__(3)));
typedef float swift_float4  __attribute__((__ext_vector_type__(4)));
typedef double swift_double2  __attribute__((__ext_vector_type__(2)));
typedef double swift_double3  __attribute__((__ext_vector_type__(3)));
typedef double swift_double4  __attribute__((__ext_vector_type__(4)));
typedef int swift_int2  __attribute__((__ext_vector_type__(2)));
typedef int swift_int3  __attribute__((__ext_vector_type__(3)));
typedef int swift_int4  __attribute__((__ext_vector_type__(4)));
typedef unsigned int swift_uint2  __attribute__((__ext_vector_type__(2)));
typedef unsigned int swift_uint3  __attribute__((__ext_vector_type__(3)));
typedef unsigned int swift_uint4  __attribute__((__ext_vector_type__(4)));
#endif

#if !defined(SWIFT_PASTE)
# define SWIFT_PASTE_HELPER(x, y) x##y
# define SWIFT_PASTE(x, y) SWIFT_PASTE_HELPER(x, y)
#endif
#if !defined(SWIFT_METATYPE)
# define SWIFT_METATYPE(X) Class
#endif
#if !defined(SWIFT_CLASS_PROPERTY)
# if __has_feature(objc_class_property)
#  define SWIFT_CLASS_PROPERTY(...) __VA_ARGS__
# else
#  define SWIFT_CLASS_PROPERTY(...) 
# endif
#endif
#if !defined(SWIFT_RUNTIME_NAME)
# if __has_attribute(objc_runtime_name)
#  define SWIFT_RUNTIME_NAME(X) __attribute__((objc_runtime_name(X)))
# else
#  define SWIFT_RUNTIME_NAME(X) 
# endif
#endif
#if !defined(SWIFT_COMPILE_NAME)
# if __has_attribute(swift_name)
#  define SWIFT_COMPILE_NAME(X) __attribute__((swift_name(X)))
# else
#  define SWIFT_COMPILE_NAME(X) 
# endif
#endif
#if !defined(SWIFT_METHOD_FAMILY)
# if __has_attribute(objc_method_family)
#  define SWIFT_METHOD_FAMILY(X) __attribute__((objc_method_family(X)))
# else
#  define SWIFT_METHOD_FAMILY(X) 
# endif
#endif
#if !defined(SWIFT_NOESCAPE)
# if __has_attribute(noescape)
#  define SWIFT_NOESCAPE __attribute__((noescape))
# else
#  define SWIFT_NOESCAPE 
# endif
#endif
#if !defined(SWIFT_RELEASES_ARGUMENT)
# if __has_attribute(ns_consumed)
#  define SWIFT_RELEASES_ARGUMENT __attribute__((ns_consumed))
# else
#  define SWIFT_RELEASES_ARGUMENT 
# endif
#endif
#if !defined(SWIFT_WARN_UNUSED_RESULT)
# if __has_attribute(warn_unused_result)
#  define SWIFT_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
# else
#  define SWIFT_WARN_UNUSED_RESULT 
# endif
#endif
#if !defined(SWIFT_NORETURN)
# if __has_attribute(noreturn)
#  define SWIFT_NORETURN __attribute__((noreturn))
# else
#  define SWIFT_NORETURN 
# endif
#endif
#if !defined(SWIFT_CLASS_EXTRA)
# define SWIFT_CLASS_EXTRA 
#endif
#if !defined(SWIFT_PROTOCOL_EXTRA)
# define SWIFT_PROTOCOL_EXTRA 
#endif
#if !defined(SWIFT_ENUM_EXTRA)
# define SWIFT_ENUM_EXTRA 
#endif
#if !defined(SWIFT_CLASS)
# if __has_attribute(objc_subclassing_restricted)
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# else
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# endif
#endif
#if !defined(SWIFT_RESILIENT_CLASS)
# if __has_attribute(objc_class_stub)
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME) __attribute__((objc_class_stub))
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_class_stub)) SWIFT_CLASS_NAMED(SWIFT_NAME)
# else
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME)
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) SWIFT_CLASS_NAMED(SWIFT_NAME)
# endif
#endif
#if !defined(SWIFT_PROTOCOL)
# define SWIFT_PROTOCOL(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
# define SWIFT_PROTOCOL_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
#endif
#if !defined(SWIFT_EXTENSION)
# define SWIFT_EXTENSION(M) SWIFT_PASTE(M##_Swift_, __LINE__)
#endif
#if !defined(OBJC_DESIGNATED_INITIALIZER)
# if __has_attribute(objc_designated_initializer)
#  define OBJC_DESIGNATED_INITIALIZER __attribute__((objc_designated_initializer))
# else
#  define OBJC_DESIGNATED_INITIALIZER 
# endif
#endif
#if !defined(SWIFT_ENUM_ATTR)
# if __has_attribute(enum_extensibility)
#  define SWIFT_ENUM_ATTR(_extensibility) __attribute__((enum_extensibility(_extensibility)))
# else
#  define SWIFT_ENUM_ATTR(_extensibility) 
# endif
#endif
#if !defined(SWIFT_ENUM)
# define SWIFT_ENUM(_type, _name, _extensibility) enum _name : _type _name; enum SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# if __has_feature(generalized_swift_name)
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) enum _name : _type _name SWIFT_COMPILE_NAME(SWIFT_NAME); enum SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# else
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) SWIFT_ENUM(_type, _name, _extensibility)
# endif
#endif
#if !defined(SWIFT_UNAVAILABLE)
# define SWIFT_UNAVAILABLE __attribute__((unavailable))
#endif
#if !defined(SWIFT_UNAVAILABLE_MSG)
# define SWIFT_UNAVAILABLE_MSG(msg) __attribute__((unavailable(msg)))
#endif
#if !defined(SWIFT_AVAILABILITY)
# define SWIFT_AVAILABILITY(plat, ...) __attribute__((availability(plat, __VA_ARGS__)))
#endif
#if !defined(SWIFT_WEAK_IMPORT)
# define SWIFT_WEAK_IMPORT __attribute__((weak_import))
#endif
#if !defined(SWIFT_DEPRECATED)
# define SWIFT_DEPRECATED __attribute__((deprecated))
#endif
#if !defined(SWIFT_DEPRECATED_MSG)
# define SWIFT_DEPRECATED_MSG(...) __attribute__((deprecated(__VA_ARGS__)))
#endif
#if !defined(SWIFT_DEPRECATED_OBJC)
# if __has_feature(attribute_diagnose_if_objc)
#  define SWIFT_DEPRECATED_OBJC(Msg) __attribute__((diagnose_if(1, Msg, "warning")))
# else
#  define SWIFT_DEPRECATED_OBJC(Msg) SWIFT_DEPRECATED_MSG(Msg)
# endif
#endif
#if defined(__OBJC__)
#if !defined(IBSegueAction)
# define IBSegueAction 
#endif
#endif
#if !defined(SWIFT_EXTERN)
# if defined(__cplusplus)
#  define SWIFT_EXTERN extern "C"
# else
#  define SWIFT_EXTERN extern
# endif
#endif
#if !defined(SWIFT_CALL)
# define SWIFT_CALL __attribute__((swiftcall))
#endif
#if !defined(SWIFT_INDIRECT_RESULT)
# define SWIFT_INDIRECT_RESULT __attribute__((swift_indirect_result))
#endif
#if !defined(SWIFT_CONTEXT)
# define SWIFT_CONTEXT __attribute__((swift_context))
#endif
#if !defined(SWIFT_ERROR_RESULT)
# define SWIFT_ERROR_RESULT __attribute__((swift_error_result))
#endif
#if defined(__cplusplus)
# define SWIFT_NOEXCEPT noexcept
#else
# define SWIFT_NOEXCEPT 
#endif
#if !defined(SWIFT_C_INLINE_THUNK)
# if __has_attribute(always_inline)
# if __has_attribute(nodebug)
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline)) __attribute__((nodebug))
# else
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline))
# endif
# else
#  define SWIFT_C_INLINE_THUNK inline
# endif
#endif
#if defined(_WIN32)
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL __declspec(dllimport)
#endif
#else
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL 
#endif
#endif
#if defined(__OBJC__)
#if __has_feature(objc_modules)
#if __has_warning("-Watimport-in-framework-header")
#pragma clang diagnostic ignored "-Watimport-in-framework-header"
#endif
@import Foundation;
@import ObjectiveC;
@import Security;
#endif

#endif
#pragma clang diagnostic ignored "-Wproperty-attribute-mismatch"
#pragma clang diagnostic ignored "-Wduplicate-method-arg"
#if __has_warning("-Wpragma-clang-attribute")
# pragma clang diagnostic ignored "-Wpragma-clang-attribute"
#endif
#pragma clang diagnostic ignored "-Wunknown-pragmas"
#pragma clang diagnostic ignored "-Wnullability"
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"
#pragma clang diagnostic ignored "-Wunsafe-buffer-usage"

#if __has_attribute(external_source_symbol)
# pragma push_macro("any")
# undef any
# pragma clang attribute push(__attribute__((external_source_symbol(language="Swift", defined_in="LicenseSpring",generated_declaration))), apply_to=any(function,enum,objc_interface,objc_category,objc_protocol))
# pragma pop_macro("any")
#endif

#if defined(__OBJC__)

/// License authorization method.
typedef SWIFT_ENUM_NAMED(NSInteger, LSAuthorizationMethod, "AuthorizationMethod", open) {
  LSAuthorizationMethodUnknown = 0,
  LSAuthorizationMethodLicenseKey = 1,
  LSAuthorizationMethodUser = 2,
};

@class NSString;
@class NSDate;
/// Application available version information.
SWIFT_CLASS_NAMED("AvailableVersion")
@interface LSAvailableVersion : NSObject
/// Available version.
@property (nonatomic, copy) NSString * _Nonnull version;
/// Release date.
@property (nonatomic, copy) NSDate * _Nonnull releaseDate;
- (nonnull instancetype)initWithVersion:(NSString * _Nonnull)version releaseDate:(NSDate * _Nonnull)releaseDate OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class LSConfiguration;
@class NSURL;
/// Entry point to the LicenseSpring SDK
/// Use to obtain the license or common product information
SWIFT_CLASS_NAMED("BaseManager")
@interface LSBaseManager : NSObject
/// Init LicenseManager with configuration
/// \param configuration Configuration of LicenseManager
///
///
/// throws:
/// <code>LSError</code> if input configuration is wrong
- (nullable instancetype)initWithConfiguration:(LSConfiguration * _Nonnull)configuration error:(NSError * _Nullable * _Nullable)error OBJC_DESIGNATED_INITIALIZER;
/// Manager configuration
@property (nonatomic, strong) LSConfiguration * _Nonnull configuration;
/// Filesystem path to the license.
@property (nonatomic, readonly, copy) NSURL * _Nonnull licenseFile;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class LSLicense;
/// Entry point to the LicenseSpring SDK
/// Class for performing basic requests to LicenseSpring backend and managing license bundles
SWIFT_CLASS_NAMED("BundleManager")
@interface LSBundleManager : LSBaseManager
/// Initializes the BundleManager with the given configuration
/// \param configuration LicenseSpring configuration object
///
///
/// throws:
/// <code>LSError</code> if configuration is invalid
- (nullable instancetype)initWithConfiguration:(LSConfiguration * _Nonnull)configuration error:(NSError * _Nullable * _Nullable)error OBJC_DESIGNATED_INITIALIZER;
/// Activated Bundle or empty dictionary if no license is active.
@property (nonatomic, copy) NSDictionary<NSString *, LSLicense *> * _Nonnull cachedLicenses;
/// Activate the bundle using license key.
/// \param licenseKey License key for the product.
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Activated bundle.
- (NSDictionary<NSString *, LSLicense *> * _Nullable)activateBundleWithLicenseKey:(NSString * _Nonnull)licenseKey error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate the license bundle using username and password.
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
/// \param serverID license ID, typically 64-bit id.
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.    @objc
///
/// returns:
/// Activated bundle.
- (NSDictionary<NSString *, LSLicense *> * _Nullable)activateBundleWithUsername:(NSString * _Nonnull)username password:(NSString * _Nonnull)password serverId:(int64_t)serverId error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate the bundle using idToken
/// \param idToken 
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Activated bundle.
- (NSDictionary<NSString *, LSLicense *> * _Nullable)activateBundleWithIdToken:(NSString * _Nonnull)idToken error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate the bundle using code
/// \param code 
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Activated bundle.
- (NSDictionary<NSString *, LSLicense *> * _Nullable)activateBundleWithCode:(NSString * _Nonnull)code error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Deactivates the license bundle using licenseKey.
/// \param licenseKey License key for the product
///
/// \param removeLocalData flag to remove local bundle data
///
///
/// returns:
/// True if the deactivation is successfull
- (BOOL)deactivateBundleWithLicenseKey:(NSString * _Nonnull)licenseKey removeLocalData:(BOOL)removeLocalData SWIFT_WARN_UNUSED_RESULT;
/// Deactivates the license bundle using username and password.
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
/// \param removeLocalData flag to remove local bundle data
///
///
/// returns:
/// True if the deactivation is successfull
- (BOOL)deactivateBundleWithUsername:(NSString * _Nonnull)username password:(NSString * _Nonnull)password removeLocalData:(BOOL)removeLocalData SWIFT_WARN_UNUSED_RESULT;
/// Deactivates the license bundle using idToken and customerAccountCode.
/// \param idToken 
///
/// \param customerAccountCode .
///
/// \param removeLocalData flag to remove local bundle data
///
///
/// returns:
/// True if the deactivation is successfull
- (BOOL)deactivateBundleWithIdToken:(NSString * _Nonnull)idToken customerAccountCode:(NSString * _Nonnull)customerAccountCode removeLocalData:(BOOL)removeLocalData SWIFT_WARN_UNUSED_RESULT;
/// Deactivates the license bundle using code and customerAccountCode.
/// \param code 
///
/// \param customerAccountCode .
///
/// \param removeLocalData flag to remove local bundle data
///
///
/// returns:
/// True if the deactivation is successfull
- (BOOL)deactivateBundleWithCode:(NSString * _Nonnull)code customerAccountCode:(NSString * _Nonnull)customerAccountCode removeLocalData:(BOOL)removeLocalData SWIFT_WARN_UNUSED_RESULT;
/// Check bundle for validity on the LicenseSpring platform.
/// \param licenseKey License key for the product.
///
///
/// throws:
/// Error if remote or local checks fail.
///
/// returns:
/// Current bundle.
- (NSDictionary<NSString *, LSLicense *> * _Nullable)checkBundleWithLicenseKey:(NSString * _Nonnull)licenseKey error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Check bundle for validity on the LicenseSpring platform.
/// \param username User ID, typically email in lowercase.
///
///
/// throws:
/// Error if remote or local checks fail.
///
/// returns:
/// Current bundle.
- (NSDictionary<NSString *, LSLicense *> * _Nullable)checkBundleWithUsername:(NSString * _Nonnull)username error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Retrieve URL for Single Sign-On license activation.
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// URL for Single Sign-On.
- (NSURL * _Nullable)requestSSOURLAndReturnError:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate the license using license activation response file.
/// \param activationResponseFile Activation response file location.
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Activated license bundle.
- (NSDictionary<NSString *, LSLicense *> * _Nullable)activateBundleOffline:(NSURL * _Nonnull)activationResponseFile error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Creates offline activation file request.
/// \param licenseKey License key to be activated offline.
///
/// \param preferredLocation Optional custom activation request file location. ‘~/Desktop/ls_activation.req’ by default.
///
///
/// throws:
/// Error if create activation file fails. May be of <code>LSError</code> type.
///
/// returns:
/// Location of offline activation file request.
- (NSURL * _Nullable)createOfflineActivationFileWithLicenseKey:(NSString * _Nonnull)licenseKey preferredLocation:(NSURL * _Nullable)preferredLocation error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Creates offline activation file request.
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
/// \param preferredLocation Optional custom activation request file location. ‘~/Desktop/ls_activation.req’ by default.
///
/// \param serverID serverID, server-side license identifier, typically 64-bit id.
///
///
/// throws:
/// Error if create activation file fails. May be of <code>LSError</code> type.
///
/// returns:
/// Location of offline activation file request.
- (NSURL * _Nullable)createOfflineActivationFileWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password preferredLocation:(NSURL * _Nullable)preferredLocation serverID:(int64_t)serverID error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Creates the deactivate bundle offline request
/// \param licenseKey licenseKey: License key to be activated offline.
///
- (NSURL * _Nullable)deactivateBundleOfflineWithLicenseKey:(NSString * _Nonnull)licenseKey serverID:(int64_t)serverID preferredLocation:(NSURL * _Nullable)preferredLocation error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Creates the deactivate bundle offline request
/// \param username User ID, typically email in lowercase.
///
- (NSURL * _Nullable)deactivateBundleOfflineWithUsername:(NSString * _Nonnull)username serverID:(int64_t)serverID preferredLocation:(NSURL * _Nullable)preferredLocation error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// Company related to the license
SWIFT_CLASS_NAMED("Company")
@interface LSCompany : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@protocol LicenseCryptor;
@class ExtendedOptions;
@class OAuthCredentials;
/// LicenseSpring SDK configuration.
SWIFT_CLASS_NAMED("Configuration")
@interface LSConfiguration : NSObject <NSCopying>
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
/// API key acquired from LicenseSpring.
@property (nonatomic, copy) NSString * _Nonnull apiKey;
/// Shared key acquired from LicenseSpring.
@property (nonatomic, copy) NSString * _Nonnull sharedKey;
/// Product code code acquired from LicenseSpring.
@property (nonatomic, copy) NSString * _Nonnull productCode;
/// Application name. Defaults to main application bundle name if not set.
@property (nonatomic, copy) NSString * _Nonnull appName;
/// Application version. Defaults to main application bundle short version if not set.
@property (nonatomic, copy) NSString * _Nonnull appVersion;
/// Customer group (account) code that is required for SSO.
/// note:
/// Meaningful for user-based auth only. If you don’t plan to provide SSO you can ignore this method.
/// By default empty. Contact support to get more details implementing SSO.
@property (nonatomic, copy) NSString * _Nullable customerAccountCode;
/// Air gap public key.
@property (nonatomic, copy) NSString * _Nullable airgapKey;
/// Custom name of local license file.
@property (nonatomic, copy) NSString * _Nonnull licenseFileName;
/// Custom directory containing local license file.
@property (nonatomic, copy) NSURL * _Nonnull licenseDirectoryPath;
/// Alternate base URL for LicenseSpring API.
/// note:
/// In general should not be used in client code.
@property (nonatomic, copy) NSURL * _Nonnull serviceURL;
/// Custom hardware ID of the device.
@property (nonatomic, copy) NSString * _Nonnull hardwareID;
/// Boolean indicates if SDK should send host, local IP and MAC to the LicenseSpring platform.
@property (nonatomic) BOOL collectHostNameAndLocalIP;
/// Timeout value for network operations.
@property (nonatomic) NSTimeInterval networkTimeout;
/// Timeout value for network operations.
@property (nonatomic, strong) id <LicenseCryptor> _Nonnull licenseCryptor;
/// HTTPs proxy host.
@property (nonatomic, copy) NSString * _Nullable proxyHost;
/// HTTPs proxy port.
@property (nonatomic) uint16_t proxyPort;
/// License grace period in seconds.
/// If not set, then default will be 48 hours.
/// Set 0 to disable grace period.
/// For cloud floating licenses grace period on license check is enabled
/// if more than an hour of floating period remains.
@property (nonatomic) NSTimeInterval gracePeriod;
/// ClientID
@property (nonatomic, copy) NSString * _Nonnull client_id;
/// Client Secret
@property (nonatomic, copy) NSString * _Nonnull client_secret;
/// Crypto Provider Key
@property (nonatomic, copy) NSString * _Nonnull CryptoProviderKey;
/// IsOAuth
@property (nonatomic) BOOL isOauth;
/// ProtectOfflineActivation
@property (nonatomic, readonly) BOOL isGuardFileEnabled;
/// ExtendedOptions
@property (nonatomic, strong) ExtendedOptions * _Nullable extendedOptions;
/// IsLoggingEnabled
@property (nonatomic) BOOL isLoggingEnabled;
/// Whether detection of Virtual machines is enabled
@property (nonatomic, readonly) BOOL isVMDetectionEnabled;
/// In case VM detection enabled returns true if app currently running in virtualized environment
@property (nonatomic, readonly) BOOL isVM;
/// Detected virtual machine name
@property (nonatomic, readonly, copy) NSString * _Nullable detectedVMName;
/// PublicKey
@property (nonatomic, copy) NSString * _Nonnull publicKey;
/// PublicKey from base64 String
@property (nonatomic, readonly) SecKeyRef _Nullable publicKeyFromBase64;
- (nonnull instancetype)initWithApiKey:(NSString * _Nonnull)apiKey sharedKey:(NSString * _Nonnull)sharedKey productCode:(NSString * _Nonnull)productCode publicKey:(NSString * _Nullable)publicKey extendedOptions:(ExtendedOptions * _Nullable)extendedOptions OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithOAuthCredentials:(OAuthCredentials * _Nonnull)oAuthCredentials productCode:(NSString * _Nonnull)productCode publicKey:(NSString * _Nullable)publicKey extendedOptions:(ExtendedOptions * _Nullable)extendedOptions OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@interface LSConfiguration (SWIFT_EXTENSION(LicenseSpring))
/// Full path to the license file.
@property (nonatomic, readonly, copy) NSURL * _Nonnull licenseFile;
@end

/// License authorization method.
typedef SWIFT_ENUM_NAMED(NSInteger, LSConsumptionPeriod, "ConsumptionPeriod", open) {
  LSConsumptionPeriodUnknown = 0,
  LSConsumptionPeriodDaily = 1,
  LSConsumptionPeriodWeekly = 2,
  LSConsumptionPeriodMonthly = 3,
  LSConsumptionPeriodAnnually = 4,
};

/// License custom field information.
SWIFT_CLASS_NAMED("CustomField")
@interface LSCustomField : NSObject
/// Custom field name.
@property (nonatomic, copy) NSString * _Nonnull name;
/// Custom field value.
@property (nonatomic, copy) NSString * _Nonnull value;
- (nonnull instancetype)initWithName:(NSString * _Nonnull)name value:(NSString * _Nonnull)value OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS("_TtC13LicenseSpring14CustomFieldDto")
@interface CustomFieldDto : NSObject
/// The name of the custom field
@property (nonatomic, copy) NSString * _Nonnull name;
/// The value of the custom field
@property (nonatomic, copy) NSString * _Nonnull value;
/// Reserved for future use
@property (nonatomic, copy) NSString * _Nullable valueType;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class NSData;
/// LicenseSpring Customer information.
SWIFT_CLASS_NAMED("Customer")
@interface LSCustomer : NSObject
/// Customer email address.
@property (nonatomic, copy) NSString * _Nullable email;
/// Customer first name.
@property (nonatomic, copy) NSString * _Nullable firstName;
/// Customer last name.
@property (nonatomic, copy) NSString * _Nullable lastName;
/// Customer company name.
@property (nonatomic, copy) NSString * _Nullable company;
/// Customer phone number.
@property (nonatomic, copy) NSString * _Nullable phone;
/// Customer address.
@property (nonatomic, copy) NSString * _Nullable address;
/// Customer city.
@property (nonatomic, copy) NSString * _Nullable city;
/// Customer state.
@property (nonatomic, copy) NSString * _Nullable state;
/// Customer country.
@property (nonatomic, copy) NSString * _Nullable country;
/// Customer postcode/zipcoder.
@property (nonatomic, copy) NSString * _Nullable postcode;
/// Customer reference.
@property (nonatomic, copy) NSString * _Nullable reference;
/// Metadata JSON.
@property (nonatomic, copy) NSData * _Nullable metadata;
/// Creates <code>Customer</code> instance with parameters.
/// \param email Customer email address.
///
/// \param firstName Customer first name.
///
/// \param lastName Customer last name.
///
/// \param company Customer company name.
///
/// \param phone Customer phone number.
///
/// \param address Customer address.
///
/// \param city Customer city.
///
/// \param state Customer state.
///
/// \param country Customer country.
///
/// \param postcode Customer postcode/zipcoder.
///
/// \param reference Customer reference.
///
/// \param metadata Customer metadata JSON.
///
- (nonnull instancetype)initWithEmail:(NSString * _Nullable)email firstName:(NSString * _Nullable)firstName lastName:(NSString * _Nullable)lastName company:(NSString * _Nullable)company phone:(NSString * _Nullable)phone address:(NSString * _Nullable)address city:(NSString * _Nullable)city state:(NSString * _Nullable)state country:(NSString * _Nullable)country postcode:(NSString * _Nullable)postcode reference:(NSString * _Nullable)reference metadata:(NSData * _Nullable)metadata OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

typedef SWIFT_ENUM(NSInteger, DeviceIDAlgorithm, open) {
  DeviceIDAlgorithmDefault = 0,
};

SWIFT_CLASS_NAMED("DeviceVariable")
@interface LSDeviceVariable : NSObject
/// Variable ID.
@property (nonatomic) NSInteger id;
/// Name of the variable.
@property (nonatomic, copy) NSString * _Nonnull variable;
/// Value of the variable.
@property (nonatomic, copy) NSString * _Nonnull value;
/// Date when the variable has been set.
@property (nonatomic, copy) NSDate * _Nonnull createdAt;
/// Device ID related the variable is bound to.
@property (nonatomic) NSInteger deviceID;
- (nonnull instancetype)initWithId:(NSInteger)id variable:(NSString * _Nonnull)variable value:(NSString * _Nonnull)value createdAt:(NSDate * _Nonnull)createdAt deviceID:(NSInteger)deviceID OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class ProxySettings;
SWIFT_CLASS("_TtC13LicenseSpring15ExtendedOptions")
@interface ExtendedOptions : NSObject
/// Whether to enable detection of running in a virtual machine.
@property (nonatomic) BOOL enableVMDetection;
/// Optional alternate key for authorization or license lookup.
@property (nonatomic, copy) NSString * _Nullable alternateKey;
/// Full proxy settings, including credentials and URI.
@property (nonatomic, strong) ProxySettings * _Nonnull proxy;
/// Timeout in milliseconds for cloud ID request (separate from general network timeout).
@property (nonatomic) NSInteger cloudIdRequestTimeout;
/// Algorithm to use for generating device ID.
@property (nonatomic) enum DeviceIDAlgorithm deviceIdAlgorithm;
/// Additional custom headers to include in HTTP requests.
@property (nonatomic, copy) NSDictionary<NSString *, NSString *> * _Nonnull customHeaders;
/// Optional bundle code identifier.
@property (nonatomic, copy) NSString * _Nullable bundleCode;
/// Whether to skip checking local time during airgap activation.
@property (nonatomic) BOOL airgapSkipLocalTimeCheck;
@property (nonatomic) BOOL protectOfflineActivation;
- (nonnull instancetype)initWithEnableVMDetection:(BOOL)enableVMDetection alternateKey:(NSString * _Nullable)alternateKey proxy:(ProxySettings * _Nonnull)proxy cloudIdRequestTimeout:(NSInteger)cloudIdRequestTimeout deviceIdAlgorithm:(enum DeviceIDAlgorithm)deviceIdAlgorithm customHeaders:(NSDictionary<NSString *, NSString *> * _Nonnull)customHeaders bundleCode:(NSString * _Nullable)bundleCode airgapSkipLocalTimeCheck:(BOOL)airgapSkipLocalTimeCheck protectOfflineActivation:(BOOL)protectOfflineActivation OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS("_TtC13LicenseSpring14FloatingClient")
@interface FloatingClient : NSObject
@property (nonatomic, readonly, strong) LSConfiguration * _Nonnull configuration;
/// Init FloatingClient with configuration.
/// \param configuration Configuration of FloatingClient.
///
///
/// throws:
/// <code>LSError</code> if input configuration is wrong.
- (nullable instancetype)initWithConfiguration:(LSConfiguration * _Nonnull)configuration error:(NSError * _Nullable * _Nullable)error OBJC_DESIGNATED_INITIALIZER;
/// Filesystem path to the license.
@property (nonatomic, readonly, copy) NSURL * _Nonnull licenseFile;
/// Activated License or nil if no license is active.
@property (nonatomic, readonly, strong) LSLicense * _Nullable currentLicense;
/// Register client with given id.
/// Send register license request to the Floating server.
/// \param userID User or instance id for license registration, it can be anything - email, host or domain name, handle, etc.
///
///
/// throws:
/// <code>LSError</code> if registration fails.
///
/// returns:
/// Shared pointer to License if registration succeeded, throws exceptions in case of errors.
- (LSLicense * _Nullable)registerWithUserID:(NSString * _Nonnull)userID error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Unregister client with given id.
/// \param id User or instance id, it can be anything - email, host or domain name, handle, etc.
///
///
/// throws:
/// <code>LSError</code> if unregistration fails.
- (BOOL)unregisterWithUserID:(NSString * _Nonnull)userID error:(NSError * _Nullable * _Nullable)error;
/// Remove license file and internal SDK files if any of them exist.
/// note:
/// Typically should be called after license deactivation in the app uninstaller.
///
/// throws:
/// Error if clearing fails.
- (BOOL)clearLocalStorageAndReturnError:(NSError * _Nullable * _Nullable)error;
/// Helper method to check connection to the Floating server.
///
/// returns:
/// <code>true</code> if SDK is able to connect to the Floating server and <code>false</code> otherwise.
- (BOOL)checkConnection SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Information about the app related to the License.
SWIFT_CLASS_NAMED("InstallationFile")
@interface LSInstallationFile : NSObject
/// InstallationFile hash.
@property (nonatomic, copy) NSString * _Nonnull hashMD5;
/// InstallationFile version.
@property (nonatomic, copy) NSString * _Nonnull version;
/// InstallationFile URL.
@property (nonatomic, copy) NSString * _Nonnull installationFileLink;
/// App version that is required to install this InstallationFile.
@property (nonatomic, copy) NSString * _Nullable requiredVersion;
/// InstallationFile release date.
@property (nonatomic, copy) NSDate * _Nullable releaseDate;
/// InstallationFile environment.
@property (nonatomic, copy) NSString * _Nullable environment;
/// InstallationFile Eula link.
@property (nonatomic, copy) NSString * _Nullable eulaLink;
/// InstallationFile release notes link.
@property (nonatomic, copy) NSString * _Nullable releaseNotesLink;
/// InstallationFile size in bytes.
@property (nonatomic) uint64_t size;
/// InstallationFile channel.
@property (nonatomic, copy) NSString * _Nullable channel;
- (nonnull instancetype)initWithHashMD5:(NSString * _Nonnull)hashMD5 version:(NSString * _Nonnull)version installationFileLink:(NSString * _Nonnull)installationFileLink OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

@class LSUser;
enum LSLicenseType : NSInteger;
enum LSLicenseStatus : NSInteger;
@class LSLicenseFeature;
@class LSProductDetails;
/// The License. Contains information about the license and set of methods to manupulate it.
SWIFT_CLASS_NAMED("License")
@interface LSLicense : NSObject
/// License configuration. Do NOT modify directly.
@property (nonatomic, readonly, strong) LSConfiguration * _Nonnull configuration;
/// License key. Exists for key-based license.
@property (nonatomic, readonly, copy) NSString * _Nullable licenseKey;
/// License user. Exists for user-based license.
@property (nonatomic, readonly, strong) LSUser * _Nullable user;
/// Product code.
@property (nonatomic, readonly, copy) NSString * _Nonnull productCode;
/// Type of license.
@property (nonatomic, readonly) enum LSLicenseType licenseType;
/// Information about license customer, commonly it’s a person or organization associated with the license.
@property (nonatomic, readonly, strong) LSCustomer * _Nonnull customer;
/// Period when the license is valid.
@property (nonatomic, readonly, copy) NSDate * _Nullable validityPeriod;
/// Maintenance period for the license.
@property (nonatomic, readonly, copy) NSDate * _Nullable maintenancePeriod;
/// The first date when the license can be activated
@property (nonatomic, readonly, copy) NSDate * _Nullable startDate;
/// The date of the last sync with the LicenseSpring platform.
@property (nonatomic, readonly, copy) NSDate * _Nonnull lastSyncDate;
/// If license is trial.
@property (nonatomic, readonly) BOOL isTrial;
/// If license is active.
@property (nonatomic, readonly) BOOL isActive;
/// If license is enabled.
@property (nonatomic, readonly) BOOL isEnabled;
/// If license was activated offline.
@property (nonatomic, readonly) BOOL isOfflineActivated;
/// If license was activated via Air-Gap.
@property (nonatomic, readonly) BOOL isAirGapActivated;
/// PolicyID related to AirGap activation.
@property (nonatomic, readonly) NSInteger policyID;
/// Installation information related to the license.
/// note:
/// To get actual installation file information, call <code>synchronize</code> method first.
@property (nonatomic, readonly, strong) LSInstallationFile * _Nullable installationFile;
/// Hardware ID related to the license.
@property (nonatomic, readonly, copy) NSString * _Nonnull hardwareID;
/// License ID related to the license.
@property (nonatomic, readonly) int64_t serverID;
/// Indicates whether negative consumption is allowed for Consumption feature.
/// Meaningful only for Consumption license features.
@property (nonatomic, readonly) BOOL allowNegativeConsumptions;
/// Is running a license on a virtual machine prevented.
@property (nonatomic, readonly) BOOL preventVM;
/// Activation date related to the license
@property (nonatomic, readonly, copy) NSDate * _Nullable activationDate;
/// Company  related to the license
@property (nonatomic, readonly, strong) LSCompany * _Nullable company;
/// Current state of the license.
@property (nonatomic, readonly) enum LSLicenseStatus state;
/// If license have been expired.
@property (nonatomic, readonly) BOOL isExpired;
/// Fast and simple way to check current local state of the license.
/// note:
/// Equivalent to isEnabled && isActive && !isExpired.
/// note:
/// It’s just basic check, you cannot be 100% sure that license is valid without online license check.
/// You still need to perform full license check for better safety.
///
/// returns:
/// If license is valid.
@property (nonatomic, readonly) BOOL isValid;
/// If license copy is unlicensed.
@property (nonatomic, readonly) BOOL isUnlicensedCopy;
/// Indicates whether the maintenance period for the current license has expired.
@property (nonatomic, readonly) BOOL isMaintenancePeriodExpired;
/// Grace period of the license.
/// note:
/// Meaningful only for <code>subscription</code> license.
@property (nonatomic, readonly) NSTimeInterval gracePeriod;
/// Check license for validity on the LicenseSpring platform.
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
///
/// throws:
/// Error if remote or local checks fail.
- (BOOL)fullCheckWithEnv:(NSString * _Nullable)env error:(NSError * _Nullable * _Nullable)error;
/// Asynchronous wrapper for full license check that avoids blocking the main thread.
/// \param env Optional environment identifier.
///
/// \param completion Completion handler called with success or error.
///
- (void)fullCheckAsyncWithEnv:(NSString * _Nullable)env completion:(void (^ _Nonnull)(NSError * _Nullable))completion;
/// Check license for validity offline.
///
/// throws:
/// Error if check fails.
///
/// returns:
/// Boolean indicates if local check passed or not.
- (BOOL)localCheckAndReturnError:(NSError * _Nullable * _Nullable)error;
/// Retrieves fresh license information from the LicenseSpring platform.
///
/// throws:
/// Error if synchronization fails.
- (BOOL)synchronizeWithEnv:(NSString * _Nullable)env error:(NSError * _Nullable * _Nullable)error;
/// How many times license already been activated.
@property (nonatomic, readonly) NSInteger timesActivated;
/// How many times license can be activated.
@property (nonatomic, readonly) NSInteger maxActivations;
/// Deactivate the license.
///
/// throws:
/// Error if deactivation fails.
- (BOOL)deactivateAndReturnError:(NSError * _Nullable * _Nullable)error;
/// Updates license with offline update file.
/// \param file Update file location.
///
///
/// throws:
/// Error if update fails.
- (BOOL)updateOfflineWith:(NSURL * _Nonnull)file error:(NSError * _Nullable * _Nullable)error;
/// Creates offline deactivation file request.
/// \param preferredRequestFile Optional custom deactivation request file location. ‘~/Desktop/ls_deactivation.req’ by default.
///
///
/// throws:
/// Error if creation of deactivation request fails.
///
/// returns:
/// Location of offline deactivation file request.
- (NSURL * _Nullable)deactivateOfflineWithPreferredRequestFile:(NSURL * _Nullable)preferredRequestFile error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Product features available for the license.
@property (nonatomic, readonly, copy) NSArray<LSLicenseFeature *> * _Nonnull features;
/// Updates feature consumption by some diff (positive or negative).
/// \param code Feature code.
///
/// \param difference Difference of consumption number.
///
///
/// throws:
/// Error if update fails.
- (BOOL)updateFeatureConsumptionWithCode:(NSString * _Nonnull)code difference:(NSInteger)difference error:(NSError * _Nullable * _Nullable)error;
/// Sync Consumption Feature(s) with the LicenseSpring platform.
/// note:
/// Meaningful only for Consumption features.
/// \param code Code of the license feature that need to be synchronized. If <code>nil</code>, sync all consumption features.
///
///
/// throws:
/// Error if sync fails.
- (BOOL)syncFeatureConsumptionWithCode:(NSString * _Nullable)code error:(NSError * _Nullable * _Nullable)error;
/// If the license is floating type.
/// Meaningful only for Floating license.
@property (nonatomic, readonly) BOOL isFloating;
/// If the license is floating type.
/// Meaningful only for Floating license.
@property (nonatomic, readonly) BOOL isOfflineFloating;
/// Maximum number of simultaneous license users (devices or instances).
/// Meaningful only for Floating license.
@property (nonatomic, readonly) NSInteger maxFloatingUsers;
/// Current number of floatings slots in use, including this user (instance).
/// The value can be actualized with <code>synchronize</code> method call.
/// Meaningful only for Floating license.
@property (nonatomic, readonly) NSInteger floatingInUseCount;
/// Timeout of the floating license.
/// Meaningful only for Floating license.
@property (nonatomic, readonly) NSTimeInterval floatingTimeout;
/// Floating user (client) or instance id that was set during registration via <code>FloatingClient</code>.
/// Meaningful only for Floating license.
@property (nonatomic, readonly, copy) NSString * _Nullable floatingClientId;
/// Floating license validity end date.
/// Meaningful only for Floating license.
@property (nonatomic, readonly, copy) NSDate * _Nullable floatingEndDate;
/// How many times license has been transferred between devices.
@property (nonatomic, readonly) NSInteger transferCount;
/// Register floating license using floatingClientId
/// In order to keep floating license alive you should check (register) it periodically.
/// This is equivalent to <code>synchronize</code> method call.
/// Meaningful only for Floating license.
- (BOOL)registerFloatingLicenseAndReturnError:(NSError * _Nullable * _Nullable)error;
/// Revoke floating license, typically should be called at the end of app execution.
/// This call will also release (return) borrowed license.
- (BOOL)releaseFloatingLicenseAndReturnError:(NSError * _Nullable * _Nullable)error;
/// If the license is borrowed.
/// Meaningful only for Floating license.
@property (nonatomic, readonly) BOOL isBorrowed;
/// If the license can be borrowed.
/// Meaningful only for Floating license.
@property (nonatomic, readonly) BOOL canBorrow;
/// The license max borrow time in seconds.
/// Meaningful only for Floating license.
@property (nonatomic, readonly) NSTimeInterval maxBorrowTime;
/// IsBundleActivated
@property (nonatomic, readonly) BOOL isBundleActivated;
/// Borrow floating license for provided time interval.
/// Meaningful only for floating licenses.
/// note:
/// More at <a href="https://docs.licensespring.com/docs/apiv4floatingborrow-1">/api/v4/floating/borrow</a>.
/// \param interval Borrow interval. If the value exceeds <code>maxBorrowTime</code>, it will be trimmed to the maximum.
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
- (BOOL)borrowFor:(NSTimeInterval)interval error:(NSError * _Nullable * _Nullable)error;
/// Borrow floating license till provided end date.
/// Meaningful only for floating licenses.
/// note:
/// More at <a href="https://docs.licensespring.com/docs/apiv4floatingborrow-1">/api/v4/floating/borrow</a>.
/// \param date Borrow end date. Pass <code>nil</code> to borrow the license for max possible period.
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
- (BOOL)borrowUntil:(NSDate * _Nullable)date error:(NSError * _Nullable * _Nullable)error;
/// Custom data fields available for the license.
@property (nonatomic, readonly, copy) NSArray<LSCustomField *> * _Nonnull customFields;
/// Internal order id.
@property (nonatomic, readonly, copy) NSString * _Nullable orderStoreID;
/// Metadata JSON.
@property (nonatomic, readonly, copy) NSData * _Nullable metadata;
/// Information about the product this license is belong to.
@property (nonatomic, readonly, strong) LSProductDetails * _Nonnull productDetails;
/// Array of variables bound to license concrete device ID.
@property (nonatomic, readonly, copy) NSArray<LSDeviceVariable *> * _Nonnull deviceVariables;
/// Sends device-specific variables to the LicenseSpring platform.
/// note:
/// More at <a href="https://licensespring.kwiki.io/docs/apiv4trackdevicevariables">/api/v4/track_device_variables</a>.
/// \param variables Dictionary of name-value pairs.
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// Array of variables linked to the current running device ID.
- (BOOL)sendDeviceVariables:(NSDictionary<NSString *, NSString *> * _Nonnull)variables error:(NSError * _Nullable * _Nullable)error;
/// Requests device-specific variables from the LicenseSpring platform.
/// If succeeds, property <code>deviceVariables</code> is also updated.
/// note:
/// Please note this data will be linked to the current running device ID.
/// note:
/// More at <a href="https://licensespring.kwiki.io/docs/apiv4getdevicevariables">/api/v4/get_device_variables</a>.
///
/// throws:
/// Error if sending data fails.
- (NSArray<LSDeviceVariable *> * _Nullable)requestDeviceVariablesAndReturnError:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request all available versions for the current license.
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// An array of versions available for the license.
- (NSArray<LSAvailableVersion *> * _Nullable)requestAvailableVersionsAndReturnError:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request installation information for the current license.
/// \param version Desired product (app) version, optional. If not provided, the last available version assumed.
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// Installation information related to the license.
- (LSInstallationFile * _Nullable)requestInstallationFileWithVersion:(NSString * _Nullable)version error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Change password for user based license.
/// note:
/// More at <a href="https://docs.licensespring.com/docs/apiv4changepassword">/api/v4/change_password</a>
/// \param password Current user password.
///
/// \param newPassword New user password.
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
- (BOOL)changePasswordWithPassword:(NSString * _Nonnull)password newPassword:(NSString * _Nonnull)newPassword error:(NSError * _Nullable * _Nullable)error;
/// If unlimited number or consumptions is allowed.
/// note:
/// Meaningful only for Consumption license.
@property (nonatomic, readonly) BOOL allowUnlimitedConsumptions;
/// If reset consumption is enabled. Refer to value in <code>consumptionPeriod</code>.
/// note:
/// Meaningful only for Consumption feature type.
@property (nonatomic, readonly) BOOL isResetConsumptionEnabled;
/// Value of reset consumption period. Makes sense only if <code>isResetConsumptionEnabled</code> is <code>true</code>.
/// note:
/// Meaningful only for Consumption feature type.
@property (nonatomic, readonly) enum LSConsumptionPeriod consumptionPeriod;
/// If it’s allowed to go over <code>maxConsumptionOverage</code>.
/// note:
/// Meaningful only for Consumption based license.
@property (nonatomic, readonly) BOOL isConsumptionOverageAllowed;
/// Maximum extra consumption value or 0 for <code>unlimited</code> value.
/// 0 if license type is not Consumption.
@property (nonatomic, readonly) NSInteger maxConsumptionOverage;
/// Change local consumption counter for consumption license.
/// note:
/// Meaningful only for Consumption based license.
/// \param difference Consumption value to be added or removed (if passed as negative).
///
///
/// throws:
/// Error if sending data fails.
- (BOOL)updateConsumptionsWithDifference:(NSInteger)difference error:(NSError * _Nullable * _Nullable)error;
/// Current total consumption or 0 if license type is not Consumption.
/// note:
/// Meaningful only for Consumption based license.
@property (nonatomic, readonly) NSInteger consumptions;
/// Maximum consumption value or 0 if license type is not Consumption.
/// note:
/// Meaningful only for Consumption based license.
@property (nonatomic, readonly) NSInteger maxComsumptions;
/// Number of local consumptions not synchornized with LicenseSpring platform.
/// May be negative.
/// note:
/// Meaningful only for Consumption feature type.
@property (nonatomic, readonly) NSInteger localConsumptionsDelta;
/// Sync Consumption license with the server.
/// note:
/// Meaningful only for Consumption based license.
///
/// throws:
/// Error if sync fails.
- (BOOL)syncConsumptionsAndReturnError:(NSError * _Nullable * _Nullable)error;
- (BOOL)registerFloatingFeature:(LSLicenseFeature * _Nonnull)licenseFeature error:(NSError * _Nullable * _Nullable)error;
- (BOOL)releaseFloatingFeature:(LSLicenseFeature * _Nonnull)licenseFeature error:(NSError * _Nullable * _Nullable)error;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_PROTOCOL("_TtP13LicenseSpring14LicenseCryptor_")
@protocol LicenseCryptor
- (NSData * _Nullable)encrypt:(NSData * _Nonnull)data SWIFT_WARN_UNUSED_RESULT;
- (NSData * _Nullable)decrypt:(NSData * _Nonnull)data SWIFT_WARN_UNUSED_RESULT;
@end

enum LSLicenseFeatureType : NSInteger;
/// License feature information.
SWIFT_CLASS_NAMED("LicenseFeature")
@interface LSLicenseFeature : NSObject
@property (nonatomic, readonly, copy) NSString * _Nonnull id;
/// Feature name.
@property (nonatomic, copy) NSString * _Nonnull name;
/// Feature code.
@property (nonatomic, copy) NSString * _Nonnull code;
/// Feature type.
@property (nonatomic) enum LSLicenseFeatureType featureType;
/// Feature type.
@property (nonatomic, copy) NSDate * _Nullable expirationDate;
/// Maximum consumption of the feature.
/// Meaningful only for consumption feature type.
@property (nonatomic) NSInteger maxConsumptions;
/// Current total consumption or 0 if license type is not Consumption.
/// note:
/// Meaningful only for Consumption feature type.
@property (nonatomic) NSInteger consumptions;
/// If unlimited number or consumptions is allowed.
/// note:
/// Meaningful only for Consumption feature type.
@property (nonatomic) BOOL allowUnlimitedConsumptions;
/// If reset consumption is enabled. Refer to value in <code>consumptionPeriod</code>.
/// note:
/// Meaningful only for Consumption feature type.
@property (nonatomic) BOOL isResetConsumptionEnabled;
/// Value of reset consumption period. Makes sense only if <code>isResetConsumptionEnabled</code> is <code>true</code>.
/// note:
/// Meaningful only for Consumption feature type.
@property (nonatomic) enum LSConsumptionPeriod consumptionPeriod;
/// Number of local consumptions not synchornized with LicenseSpring platform.
/// May be negative.
/// note:
/// Meaningful only for Consumption feature type.
@property (nonatomic) NSInteger localConsumptionsDelta;
/// If it’s allowed to go over <code>maxConsumptionOverage</code>.
/// note:
/// Meaningful only for Consumption feature type.
@property (nonatomic) BOOL isConsumptionOverageAllowed;
/// Maximum extra consumption value or 0 for <code>unlimited</code> value.
/// 0 if feature type is not Consumption.
@property (nonatomic) NSInteger maxConsumptionOverage;
/// Metadata JSON.
@property (nonatomic, copy) NSData * _Nullable metadata;
/// Indicates whether negative consumption is allowed for Consumption feature.
/// Meaningful only for Consumption license features.
@property (nonatomic) BOOL allowNegativeConsumptions;
- (nonnull instancetype)initWithName:(NSString * _Nonnull)name code:(NSString * _Nonnull)code featureType:(enum LSLicenseFeatureType)featureType isFloating:(BOOL)isFloating isOfflineFloating:(BOOL)isOfflineFloating OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// License feature type.
typedef SWIFT_ENUM_NAMED(NSInteger, LSLicenseFeatureType, "LicenseFeatureType", open) {
  LSLicenseFeatureTypeUnknown = 0,
  LSLicenseFeatureTypeActivation = 1,
  LSLicenseFeatureTypeConsumption = 2,
};

@class UserLicensesData;
/// Entry point to the LicenseSpring SDK
/// Use to obtain the license or common product information
SWIFT_CLASS_NAMED("LicenseManager")
@interface LSLicenseManager : LSBaseManager
/// Init LicenseManager with configuration
/// \param configuration Configuration of LicenseManager
///
///
/// throws:
/// <code>LSError</code> if input configuration is wrong
- (nullable instancetype)initWithConfiguration:(LSConfiguration * _Nonnull)configuration error:(NSError * _Nullable * _Nullable)error OBJC_DESIGNATED_INITIALIZER;
/// Activated License or nil if no license is active.
@property (nonatomic, readonly, strong) LSLicense * _Nullable currentLicense;
/// Activate the license using license key.
/// \param licenseKey License key for the product.
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Activated license.
- (LSLicense * _Nullable)activateLicenseWithLicenseKey:(NSString * _Nonnull)licenseKey error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate the license using a license key asynchronously.
/// \param licenseKey License key for the product.
///
/// \param completion Completion handler called with the result of the activation.
/// Returns <code>License</code> if activation succeeds, or <code>Error</code> if activation fails.
/// The error may be of <code>LSError</code> type.
///
- (void)activateLicenseWithLicenseKey:(NSString * _Nonnull)licenseKey completion:(void (^ _Nonnull)(LSLicense * _Nullable, NSError * _Nullable))completion;
/// Activate the license using user and password.
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Activated license.
- (LSLicense * _Nullable)activateLicenseWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate the license using user and password asynchronously.
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
/// \param completion Completion handler called with the result of the activation.
/// Returns <code>License</code> if activation succeeds, or <code>Error</code> if activation fails.
/// The error may be of <code>LSError</code> type.
///
- (void)activateLicenseWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password completion:(void (^ _Nonnull)(LSLicense * _Nullable, NSError * _Nullable))completion;
/// Activate the license using serverId.
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
/// \param serverID license ID, typically 64-bit id.
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Activated license.
- (LSLicense * _Nullable)activateLicenseWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password serverId:(int64_t)serverId error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate the license using user, password, and server ID asynchronously.
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
/// \param serverId License ID, typically a 64-bit ID.
///
/// \param completion Completion handler called with the result of the activation.
/// Returns <code>License</code> if activation succeeds, or <code>Error</code> if activation fails.
/// The error may be of <code>LSError</code> type.
///
- (void)activateLicenseWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password serverId:(int64_t)serverId completion:(void (^ _Nonnull)(LSLicense * _Nullable, NSError * _Nullable))completion;
/// Activate the license using license activation response file.
/// \param activationResponseFile Activation response file location.
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Activated license.
- (LSLicense * _Nullable)activateLicenseOffline:(NSURL * _Nonnull)activationResponseFile error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate the license using license activation response file asynchronously.
/// \param activationResponseFile Activation response file location.
///
/// \param completion Completion handler called with the result of the activation.
/// Returns <code>License</code> if activation succeeds, or <code>Error</code> if activation fails.
/// The error may be of <code>LSError</code> type.
///
- (void)activateLicenseOffline:(NSURL * _Nonnull)activationResponseFile completion:(void (^ _Nonnull)(LSLicense * _Nullable, NSError * _Nullable))completion;
/// Creates offline activation file request.
/// \param licenseKey License key to be activated offline.
///
/// \param preferredLocation Optional custom activation request file location. ‘~/Desktop/ls_activation.req’ by default.
///
///
/// throws:
/// Error if create activation file fails. May be of <code>LSError</code> type.
///
/// returns:
/// Location of offline activation file request.
- (NSURL * _Nullable)createOfflineActivationFileWithLicenseKey:(NSString * _Nonnull)licenseKey preferredLocation:(NSURL * _Nullable)preferredLocation error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Creates offline activation file request.
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
/// \param preferredLocation Optional custom activation request file location. ‘~/Desktop/ls_activation.req’ by default.
///
/// \param serverID serverID, server-side license identifier, typically 64-bit id.
///
///
/// throws:
/// Error if create activation file fails. May be of <code>LSError</code> type.
///
/// returns:
/// Location of offline activation file request.
- (NSURL * _Nullable)createOfflineActivationFileWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password preferredLocation:(NSURL * _Nullable)preferredLocation serverID:(int64_t)serverID error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Get Activation code for air gap activation.
/// \param initializationCode Code received from the air gap activation portal.
///
/// \param licenseKey License key of air gap license.
///
///
/// throws:
/// Error if generation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Air gap Activation code. Empty string in case of error.
- (NSString * _Nullable)generateAirGapActivationCodeWithInitializationCode:(NSString * _Nonnull)initializationCode licenseKey:(NSString * _Nonnull)licenseKey error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT SWIFT_AVAILABILITY(ios,introduced=13.0) SWIFT_AVAILABILITY(macos,introduced=10.15);
/// Verify Confirmation code for air gap activation.
/// \param confirmationCode Code received from the air gap activation portal.
///
/// \param licenseKey License key of air gap license.
///
/// \param policyID Policy id received from the air gap activation portal.
///
///
/// throws:
/// Error if verification fails. May be of <code>LSError</code> type.
- (BOOL)verifyAirGapConfirmationCodeWithConfirmationCode:(NSString * _Nonnull)confirmationCode licenseKey:(NSString * _Nonnull)licenseKey policyID:(NSInteger)policyID error:(NSError * _Nullable * _Nullable)error SWIFT_AVAILABILITY(ios,introduced=13.0) SWIFT_AVAILABILITY(macos,introduced=10.15);
/// Activate air gap license using policy file.
/// \param airGapPolicyFile License policy file path.
///
/// \param licenseKey License key.
///
/// \param policyID Id of the license policy.
///
///
/// throws:
/// Error if activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// License if activation succeeded.
- (LSLicense * _Nullable)activateLicenseWithAirgapPolicyFile:(NSURL * _Nonnull)policyFile licenseKey:(NSString * _Nonnull)licenseKey policyID:(NSInteger)policyID error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate air gap license using policy file asynchronously.
/// \param airGapPolicyFile License policy file path.
///
/// \param licenseKey License key.
///
/// \param policyID ID of the license policy.
///
/// \param completion Completion handler called with the result of the activation.
/// Returns <code>License</code> if activation succeeds, or <code>Error</code> if activation fails.
/// The error may be of <code>LSError</code> type.
///
- (void)activateLicenseWithAirgapPolicyFile:(NSURL * _Nonnull)policyFile licenseKey:(NSString * _Nonnull)licenseKey policyID:(NSInteger)policyID completion:(void (^ _Nonnull)(LSLicense * _Nullable, NSError * _Nullable))completion;
/// Retrieve URL for Single Sign-On license activation.
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// URL for Single Sign-On.
- (NSURL * _Nullable)requestSSOURLAndReturnError:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Retrieve URL for Single Sign-On license activation.
/// <ul>
///   <li>
///     completion:  URL for Single Sign-On if request succeeds, Error if request fails. May be of <code>LSError</code> type.
///   </li>
/// </ul>
- (void)requestSSOURLWithCompletion:(void (^ _Nonnull)(NSURL * _Nullable, NSError * _Nullable))completion;
/// Activate the license.
/// \param ssoToken id_token received from user authorization with SSO.
///
///
/// throws:
/// Error if license activation fails. May be of <code>LSError</code> type.
///
/// returns:
/// Activated license.
- (LSLicense * _Nullable)activateLicenseWithSsoToken:(NSString * _Nonnull)ssoToken error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Activate the license using SSO token asynchronously.
/// \param ssoToken id_token received from user authorization with SSO.
///
/// \param completion Completion handler called with the result of the activation.
/// Returns <code>License</code> if activation succeeds, or <code>Error</code> if activation fails.
/// The error may be of <code>LSError</code> type.
///
- (void)activateLicenseWithSsoToken:(NSString * _Nonnull)ssoToken completion:(void (^ _Nonnull)(LSLicense * _Nullable, NSError * _Nullable))completion;
/// Request trial license from LicenseSpring platform.
/// note:
/// Combination of same hardwareID and product will ALWAYS give you the same trial key!
/// This prevents people getting new trial keys on same computer.
/// \param email Optional email for key-based products and required user email for user-based products.
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// Trial license key or user email in case of user-based product.
- (NSString * _Nullable)requestTrialKeyWith:(NSString * _Nullable)email error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request trial license from LicenseSpring platform.
/// note:
/// Combination of same hardwareID and product will ALWAYS give you the same trial key!
/// This prevents people getting new trial keys on same computer.
/// \param customer Customer information. Optional for key-based products, but required for user-based products.
///
/// \param licensePolicy License policy code. If nil, the default license policy for the product will be used.
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// Trial license key or user email in case of user-based product.
- (NSString * _Nullable)requestTrialKeyFor:(LSCustomer * _Nullable)customer licensePolicy:(NSString * _Nullable)licensePolicy error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request trial license from LicenseSpring platform.
/// note:
/// Combination of same hardwareID and product will ALWAYS give you the same trial key!
/// This prevents people getting new trial keys on same computer.
/// \param email Optional email for key-based products and required user email for user-based products.
///
/// \param completion Trial license key or user email in case of user-based product if request succeeds, Error if request fails. May be of <code>LSError</code> type.
///
- (void)requestTrialKeyWith:(NSString * _Nullable)email completion:(void (^ _Nonnull)(NSString * _Nullable, NSError * _Nullable))completion;
/// Request all available versions for the license user.
/// \param licenseKey License key.
///
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// An array of versions available for the license.
- (NSArray<LSAvailableVersion *> * _Nullable)requestAvailableVersionsWithLicenseKey:(NSString * _Nonnull)licenseKey env:(NSString * _Nullable)env error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request all available versions for the license user.
/// \param licenseKey License key.
///
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
/// \param completion An array of versions available for the license if request succeeds, Error if request fails. May be of <code>LSError</code> type.
///
- (void)requestAvailableVersionsWithLicenseKey:(NSString * _Nonnull)licenseKey env:(NSString * _Nullable)env completion:(void (^ _Nonnull)(NSArray<LSAvailableVersion *> * _Nullable, NSError * _Nullable))completion;
/// Request all available versions for the license user.
/// \param user License user name, usually email in lowercase.
///
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// An array of versions available for the license.
- (NSArray<LSAvailableVersion *> * _Nullable)requestAvailableVersionsWithUser:(NSString * _Nonnull)user env:(NSString * _Nullable)env error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request all available versions for the license user.
/// \param user License user name, usually email in lowercase.
///
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
/// \param completion An array of versions available for the license if request succeeds, Error if request fails. May be of <code>LSError</code> type.
///
- (void)requestAvailableVersionsWithUser:(NSString * _Nonnull)user env:(NSString * _Nullable)env completion:(void (^ _Nonnull)(NSArray<LSAvailableVersion *> * _Nullable, NSError * _Nullable))completion;
/// Request installation information for the license.
/// \param licenseKey License key.
///
/// \param version Desired product (app) version, optional. If not provided, the last available version assumed.
///
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// Installation information related to the license.
- (LSInstallationFile * _Nullable)requestInstallationFileWithLicenseKey:(NSString * _Nonnull)licenseKey version:(NSString * _Nullable)version env:(NSString * _Nullable)env error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request installation information for the license.
/// \param licenseKey License key.
///
/// \param version Desired product (app) version, optional. If not provided, the last available version assumed.
///
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
/// \param completion Installation information related to the license if request succeeds, Error if request fails. May be of <code>LSError</code> type.
///
- (void)requestInstallationFileWithLicenseKey:(NSString * _Nonnull)licenseKey version:(NSString * _Nullable)version env:(NSString * _Nullable)env completion:(void (^ _Nonnull)(LSInstallationFile * _Nullable, NSError * _Nullable))completion;
/// Request installation information for the license.
/// \param user License user name, usually email in lowercase.
///
/// \param version Desired product (app) version, optional. If not provided, the last available version assumed.
///
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// Installation information related to the license.
- (LSInstallationFile * _Nullable)requestInstallationFileWithUser:(NSString * _Nonnull)user version:(NSString * _Nullable)version env:(NSString * _Nullable)env error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request installation information for the license.
/// \param user License user name, usually email in lowercase.
///
/// \param version Desired product (app) version, optional. If not provided, the last available version assumed.
///
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
/// \param completion Installation information related to the license if request succeeds, Error if request fails. May be of <code>LSError</code> type.
///
- (void)requestInstallationFileWithUser:(NSString * _Nonnull)user version:(NSString * _Nullable)version env:(NSString * _Nullable)env completion:(void (^ _Nonnull)(LSInstallationFile * _Nullable, NSError * _Nullable))completion;
/// Request information about the product from LicenseSpring platform.
/// note:
/// In offline mode data will be retrieved from license file if present.
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// Product details.
- (LSProductDetails * _Nullable)requestProductDetailsWithEnv:(NSString * _Nullable)env error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request information about the product from LicenseSpring platform.
/// note:
/// In offline mode data will be retrieved from license file if present.
/// \param env Environment identifier, e.g. “win”, “win32”, “win64”, “mac”, “linux”, “linux32”, “linux64”
///
/// \param completion Product details if request succeeds, Error if request fails. May be of <code>LSError</code> type.
///
- (void)requestProductDetailsWithEnv:(NSString * _Nullable)env completion:(void (^ _Nonnull)(LSProductDetails * _Nullable, NSError * _Nullable))completion;
/// Request all the license users on every order by some customer.
/// note:
/// More at <a href="https://docs.licensespring.com/docs/apiv4customerlicenseusers">/api/v4/customer_license_users</a>
/// \param customerEmail Customer email.
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
///
/// returns:
/// Array of the users related to the customer.
- (NSArray<LSUser *> * _Nullable)requestLicenseUsersFor:(NSString * _Nonnull)customerEmail error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Request all the license users on every order by some customer.
/// note:
/// More at <a href="https://docs.licensespring.com/docs/apiv4customerlicenseusers">/api/v4/customer_license_users</a>
/// \param customerEmail Customer email.
///
/// \param completion Array of the users related to the customer if request succeeds, Error if request fails. May be of <code>LSError</code> type.
///
- (void)requestLicenseUsersFor:(NSString * _Nonnull)customerEmail completion:(void (^ _Nonnull)(NSArray<LSUser *> * _Nullable, NSError * _Nullable))completion;
/// Change password for user based license.
/// note:
/// More at <a href="https://docs.licensespring.com/docs/apiv4changepassword">/api/v4/change_password</a>
/// \param user User email.
///
/// \param password Current user password.
///
/// \param newPassword New user password.
///
///
/// throws:
/// Error if request fails. May be of <code>LSError</code> type.
- (BOOL)changePasswordWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password newPassword:(NSString * _Nonnull)newPassword error:(NSError * _Nullable * _Nullable)error;
/// Change password for user based license.
/// note:
/// More at [/api/v4/change_password]
/// \param user User email.
///
/// \param password Current user password.
///
/// \param newPassword New user password.
///
/// \param completion Error if request fails. May be of <code>LSError</code> type.
/// [/api/v4/change_password]: https://docs.licensespring.com/docs/apiv4changepassword
///
- (void)changePasswordWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password newPassword:(NSString * _Nonnull)newPassword completion:(void (^ _Nonnull)(NSError * _Nullable))completion;
/// Helper method to check connection to the LicenseSpring platform.
///
/// returns:
/// <code>true</code> if SDK is able to connect to the LicenseSpring platform and <code>false</code> otherwise.
- (BOOL)checkConnection SWIFT_WARN_UNUSED_RESULT;
/// Helper method to check connection to the LicenseSpring platform.
/// \param completion <code>true</code> if SDK is able to connect to the LicenseSpring platform and <code>false</code> otherwise
///
- (void)checkConnectionWithCompletion:(void (^ _Nonnull)(BOOL))completion;
/// Remove license file and internal SDK files if any of them exist.
/// note:
/// Typically should be called after license deactivation in the app uninstaller.
///
/// throws:
/// Error if clearing fails.
- (BOOL)clearLocalStorageAndReturnError:(NSError * _Nullable * _Nullable)error;
/// Gets the users licences using user and password
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
///
/// returns:
/// Array of UserLicensesData
- (NSArray<UserLicensesData *> * _Nullable)getUserLicensesWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
/// Gets the users licences using user and password
/// \param user User ID, typically email in lowercase.
///
/// \param password User’s password.
///
/// \param completion Array of UserLicensesData, Error if request fails. May be of <code>LSError</code> type.
///
- (void)getUserLicensesWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password completion:(void (^ _Nonnull)(NSArray<UserLicensesData *> * _Nullable, NSError * _Nullable))completion;
/// Version of LicenseSpring SDK
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull sdkVersion;)
+ (NSString * _Nonnull)sdkVersion SWIFT_WARN_UNUSED_RESULT;
/// Version of LicenseSpring API
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) NSInteger apiVersion;)
+ (NSInteger)apiVersion SWIFT_WARN_UNUSED_RESULT;
@end

@interface LSLicenseManager (SWIFT_EXTENSION(LicenseSpring))
/// Extract SSO license token from URL.
/// \param urlString URL-like string to extract SSO token from.
///
/// \param scheme Expected URL scheme to ensure URL is valid. If scheme mismatched, the error is thrown.
///
///
/// throws:
/// Error if <code>urlString</code> has invalid format or scheme mismatched.
///
/// returns:
/// SSO token to activate the license.
+ (NSString * _Nullable)extractSSOTokenFrom:(NSString * _Nonnull)urlString scheme:(NSString * _Nonnull)scheme error:(NSError * _Nullable * _Nullable)error SWIFT_WARN_UNUSED_RESULT;
@end

/// License status.
typedef SWIFT_ENUM_NAMED(NSInteger, LSLicenseStatus, "LicenseState", open) {
  LSLicenseStatusActive = 0,
  LSLicenseStatusInactive = 1,
  LSLicenseStatusExpired = 2,
  LSLicenseStatusDisabled = 3,
};

/// License type.
typedef SWIFT_ENUM_NAMED(NSInteger, LSLicenseType, "LicenseType", open) {
  LSLicenseTypeUnknown = 0,
  LSLicenseTypePerpetual = 1,
  LSLicenseTypeSubscription = 2,
  LSLicenseTypeTimeLimited = 3,
  LSLicenseTypeConsumption = 4,
};

/// License user class that encapsulates information about the license user
SWIFT_CLASS("_TtC13LicenseSpring11LicenseUser")
@interface LicenseUser : NSObject
/// Id of the license user
@property (nonatomic) uint64_t id;
/// License user email address
@property (nonatomic, copy) NSString * _Nullable email;
/// Is the user active
@property (nonatomic) BOOL isActive;
/// License user first name
@property (nonatomic, copy) NSString * _Nullable firstName;
/// License user last name
@property (nonatomic, copy) NSString * _Nullable lastName;
/// License user phone number
@property (nonatomic, copy) NSString * _Nullable phone;
/// Does the user use initial password or already changed the password
/// True if initial password in use and false otherwise
@property (nonatomic) BOOL isInitialPassword;
/// License user initial password
@property (nonatomic, copy) NSString * _Nullable initialPassword;
/// License id of the user’s license
@property (nonatomic) uint64_t licenseId;
/// Store id of the order
@property (nonatomic, copy) NSString * _Nullable orderStoreId;
/// Id of the order
@property (nonatomic) uint64_t orderId;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Container class for OAuth credentials. Used for license manager initialization instead of api/public key.
SWIFT_CLASS("_TtC13LicenseSpring16OAuthCredentials")
@interface OAuthCredentials : NSObject
/// OAuth client ID.
@property (nonatomic, copy) NSString * _Nonnull clientId;
/// OAuth client secret.
@property (nonatomic, copy) NSString * _Nonnull clientSecret;
/// Key used for default ICryptoProvider implementation. You can ignore this if you will provide a custom ICryptoProvider, otherwise you need to provide a cryptography key.
@property (nonatomic, copy) NSString * _Nonnull cryptoProviderKey;
- (nullable instancetype)initWithClientId:(NSString * _Nonnull)clientId clientSecret:(NSString * _Nonnull)clientSecret error:(NSError * _Nullable * _Nullable)error OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// LicenseSpring Product details.
SWIFT_CLASS_NAMED("ProductDetails")
@interface LSProductDetails : NSObject
/// Product name.
@property (nonatomic, copy) NSString * _Nonnull productName;
/// Product short code.
@property (nonatomic, copy) NSString * _Nonnull productCode;
/// Authorization method of the product.
@property (nonatomic) enum LSAuthorizationMethod authorizationMethod;
/// Is trial allowed for the product or not.
@property (nonatomic) BOOL isTrialAllowed;
/// Trial period in days.
@property (nonatomic) NSInteger trialPeriod;
/// Is overages allowed for the product or not.
@property (nonatomic) BOOL isOveragesAllowed;
/// Maximum overages count.
@property (nonatomic) NSInteger maxOverages;
/// Metadata JSON.
@property (nonatomic, copy) NSData * _Nullable metadata;
/// Company  related to the license
@property (nonatomic, strong) LSCompany * _Nullable company;
- (nonnull instancetype)initWithProductName:(NSString * _Nonnull)productName productCode:(NSString * _Nonnull)productCode authorizationMethod:(enum LSAuthorizationMethod)authorizationMethod OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS("_TtC13LicenseSpring13ProxySettings")
@interface ProxySettings : NSObject
@property (nonatomic, copy) NSString * _Nullable proxyUri;
@property (nonatomic, copy) NSString * _Nullable user;
@property (nonatomic, copy) NSString * _Nullable password;
@property (nonatomic) BOOL useDefaultCredentials;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithProxyUri:(NSString * _Nonnull)proxyUri useDefaultCredentials:(BOOL)useDefaultCredentials OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)initWithUser:(NSString * _Nonnull)user password:(NSString * _Nonnull)password proxyUri:(NSString * _Nullable)proxyUri OBJC_DESIGNATED_INITIALIZER;
@end

/// LicenseSpring User information.
SWIFT_CLASS_NAMED("User")
@interface LSUser : NSObject
/// User email.
@property (nonatomic, copy) NSString * _Nonnull email;
/// User id.
@property (nonatomic) NSInteger id;
/// User true email.
@property (nonatomic, copy) NSString * _Nullable trueEmail;
/// Date when the user has been created.
@property (nonatomic, copy) NSDate * _Nullable createdAt;
/// Date when the user information has been updated.
@property (nonatomic, copy) NSDate * _Nullable updatedAt;
/// If the user is active.
@property (nonatomic) BOOL isActive;
/// If the user is manager.
@property (nonatomic) BOOL isManager;
/// User last login date (UTC).
@property (nonatomic, copy) NSDate * _Nullable lastLogin;
/// User initial password.
@property (nonatomic, copy) NSString * _Nullable initialPassword;
/// If password is initial.
@property (nonatomic) BOOL isInitialPassword;
/// User first name.
@property (nonatomic, copy) NSString * _Nullable firstName;
/// User last name.
@property (nonatomic, copy) NSString * _Nullable lastName;
/// User phone number.
@property (nonatomic, copy) NSString * _Nullable phoneNumber;
- (nonnull instancetype)initWithEmail:(NSString * _Nonnull)email OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS("_TtC13LicenseSpring11UserLicense")
@interface UserLicense : NSObject
/// Internal id of the license. Use this property for activating a specific license if a user has multiple licenses for the same product.
@property (nonatomic) int64_t id;
/// Id of the license in the LicenseSpring platform.
@property (nonatomic, copy) NSString * _Nullable orderStoreId;
/// Is license currently activated.
@property (nonatomic) BOOL licenseActive;
/// Is license currently enabled.
@property (nonatomic) BOOL licenseEnabled;
/// Type of the license (perpetual, subscription, time-limited, or consumption).
@property (nonatomic, readonly) enum LSLicenseType licenseType;
/// Is the license a trial version.
@property (nonatomic) BOOL isTrial;
/// Maximum number of users for this license.
@property (nonatomic) NSInteger maxLicenseUsers;
/// Date until which the license is valid.
@property (nonatomic, readonly, copy) NSDate * _Nullable validityPeriod;
/// Is maintenance period enabled.
@property (nonatomic) BOOL enableMaintenancePeriod;
/// Date until which the maintenance period is active.
@property (nonatomic, readonly, copy) NSDate * _Nullable maintenancePeriod;
/// Is grace period allowed (for subscription based licenses).
@property (nonatomic) BOOL allowGracePeriod;
/// Grace period in hours (for subscription based licenses).
@property (nonatomic) NSInteger gracePeriod;
/// Maximum number of license activations.
@property (nonatomic) NSInteger maxActivations;
/// Is unlimited number of activations allowed.
@property (nonatomic) BOOL allowUnlimitedActivations;
/// Number of time the license has been activated.
@property (nonatomic) NSInteger timesActivated;
/// First day of license activation. License can not be activated before this date.
@property (nonatomic, readonly, copy) NSDate * _Nullable startDate;
/// Number of license transfers. License transfer is an activation on a device different from the device it was last activated on.
@property (nonatomic) NSInteger transferCount;
/// Maximum number of times a license can be transfered between devices.
@property (nonatomic) NSInteger maxTransfers;
/// Are license overages allowed. In a consumption license, an overage is an additional usage beyond the predefined limit set during license creation.
@property (nonatomic) BOOL allowOverages;
/// Maximum number of license overages.
@property (nonatomic) NSInteger maxOverages;
/// Is the license a floating cloud license.
@property (nonatomic) BOOL isFloatingCloud;
/// Is the license a floating license.
@property (nonatomic) BOOL isFloating;
/// Time interval in minutes in which the end user application will need to perform a license check in order to remain registered to the license.
@property (nonatomic) int64_t floatingTimeout;
/// Can a floating license be borrowed.
@property (nonatomic) BOOL canBorrow;
/// Maximum number of hours a floating license can be borrowed for.
@property (nonatomic) int64_t maxBorrowTime;
/// Is running a license on a virtual machine prevented.
@property (nonatomic) BOOL preventVm;
/// License custom fields.
@property (nonatomic, copy) NSArray<LSCustomField *> * _Nonnull customFields;
/// License features.
@property (nonatomic, copy) NSArray<LSLicenseFeature *> * _Nonnull licenseFeatures;
/// License customer.
@property (nonatomic, strong) LSCustomer * _Nullable customer;
/// If the license is using a hardware key for authentication.
@property (nonatomic) BOOL isHardwareKeyAuthenticated;
/// Is the license airgapped.
@property (nonatomic) BOOL isAirGapped;
/// License metadata.
@property (nonatomic, copy) NSString * _Nullable metadata;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS("_TtC13LicenseSpring16UserLicensesData")
@interface UserLicensesData : NSObject
@property (nonatomic, readonly, strong) UserLicense * _Nullable license;
@property (nonatomic, readonly, strong) LicenseUser * _Nullable user;
- (nonnull instancetype)initWithUserLicense:(UserLicense * _Nonnull)userLicense licenseUser:(LicenseUser * _Nonnull)licenseUser OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

#endif
#if __has_attribute(external_source_symbol)
# pragma clang attribute pop
#endif
#if defined(__cplusplus)
#endif
#pragma clang diagnostic pop
#endif

#else
#error unsupported Swift architecture
#endif
